/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.util;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.tasks.util.DetailBuilder;
import hudson.plugins.tasks.util.model.AnnotationContainer;
import hudson.plugins.tasks.util.model.FileAnnotation;
import hudson.plugins.tasks.util.model.Priority;
import java.util.Collection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationsDetail
extends AnnotationContainer
implements ModelObject {
    private static final long serialVersionUID = 1750266351592937774L;
    private final AbstractBuild<?, ?> owner;
    private final String defaultEncoding;

    public AbstractAnnotationsDetail(AbstractBuild<?, ?> owner, Collection<FileAnnotation> annotations, String defaultEncoding, String name, AnnotationContainer.Hierarchy hierarchy) {
        super(name, hierarchy);
        this.owner = owner;
        this.defaultEncoding = defaultEncoding;
        this.addAnnotations(annotations);
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public String getHeader() {
        return this.getName() + " - " + this.getDisplayName();
    }

    public final AbstractBuild<?, ?> getOwner() {
        return this.owner;
    }

    public final boolean isCurrent() {
        return ((AbstractBuild)this.owner.getProject().getLastBuild()).number == this.owner.number;
    }

    public String getLocalizedPriority(String priorityName) {
        return Priority.fromString(priorityName).getLongLocalizedString();
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        return DetailBuilder.create().createDetails(link, this.owner, this.getContainer(), this.defaultEncoding, this.getDisplayName());
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }
}

