// CHECKSTYLE:OFF

package hudson.plugins.tasks;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;

@SuppressWarnings({
    "",
    "PMD"
})
public class Messages {

    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Open tasks trend graph (new vs. fixed)
     * 
     */
    public static String Portlet_WarningsNewVsFixedGraph() {
        return holder.format("Portlet.WarningsNewVsFixedGraph");
    }

    /**
     * Open tasks trend graph (new vs. fixed)
     * 
     */
    public static Localizable _Portlet_WarningsNewVsFixedGraph() {
        return new Localizable(holder, "Portlet.WarningsNewVsFixedGraph");
    }

    /**
     * Open tasks per project
     * 
     */
    public static String Portlet_WarningsTable() {
        return holder.format("Portlet.WarningsTable");
    }

    /**
     * Open tasks per project
     * 
     */
    public static Localizable _Portlet_WarningsTable() {
        return new Localizable(holder, "Portlet.WarningsTable");
    }

    /**
     * Fixed Open Tasks
     * 
     */
    public static String FixedTasksDetail_Name() {
        return holder.format("FixedTasksDetail.Name");
    }

    /**
     * Fixed Open Tasks
     * 
     */
    public static Localizable _FixedTasksDetail_Name() {
        return new Localizable(holder, "FixedTasksDetail.Name");
    }

    /**
     * Namespace
     * 
     */
    public static String Tasks_NamespaceDetail() {
        return holder.format("Tasks.NamespaceDetail");
    }

    /**
     * Namespace
     * 
     */
    public static Localizable _Tasks_NamespaceDetail() {
        return new Localizable(holder, "Tasks.NamespaceDetail");
    }

    /**
     * {0} closed tasks
     * 
     */
    public static String Tasks_ResultAction_MultipleFixedWarnings(Object arg1) {
        return holder.format("Tasks.ResultAction.MultipleFixedWarnings", arg1);
    }

    /**
     * {0} closed tasks
     * 
     */
    public static Localizable _Tasks_ResultAction_MultipleFixedWarnings(Object arg1) {
        return new Localizable(holder, "Tasks.ResultAction.MultipleFixedWarnings", arg1);
    }

    /**
     * Open Tasks
     * 
     */
    public static String Tasks_ProjectAction_Name() {
        return holder.format("Tasks.ProjectAction.Name");
    }

    /**
     * Open Tasks
     * 
     */
    public static Localizable _Tasks_ProjectAction_Name() {
        return new Localizable(holder, "Tasks.ProjectAction.Name");
    }

    /**
     * in {0} workspace files
     * 
     */
    public static String Tasks_ResultAction_MultipleFiles(Object arg1) {
        return holder.format("Tasks.ResultAction.MultipleFiles", arg1);
    }

    /**
     * in {0} workspace files
     * 
     */
    public static Localizable _Tasks_ResultAction_MultipleFiles(Object arg1) {
        return new Localizable(holder, "Tasks.ResultAction.MultipleFiles", arg1);
    }

    /**
     * Open Tasks Trend
     * 
     */
    public static String Tasks_Trend_Name() {
        return holder.format("Tasks.Trend.Name");
    }

    /**
     * Open Tasks Trend
     * 
     */
    public static Localizable _Tasks_Trend_Name() {
        return new Localizable(holder, "Tasks.Trend.Name");
    }

    /**
     * in 1 workspace file
     * 
     */
    public static String Tasks_ResultAction_OneFile() {
        return holder.format("Tasks.ResultAction.OneFile");
    }

    /**
     * in 1 workspace file
     * 
     */
    public static Localizable _Tasks_ResultAction_OneFile() {
        return new Localizable(holder, "Tasks.ResultAction.OneFile");
    }

    /**
     * Task Scanner: no open tasks found.
     * 
     */
    public static String Tasks_ResultAction_HealthReportNoItem() {
        return holder.format("Tasks.ResultAction.HealthReportNoItem");
    }

    /**
     * Task Scanner: no open tasks found.
     * 
     */
    public static Localizable _Tasks_ResultAction_HealthReportNoItem() {
        return new Localizable(holder, "Tasks.ResultAction.HealthReportNoItem");
    }

    /**
     * Task Scanner: {0} open tasks found.
     * 
     */
    public static String Tasks_ResultAction_HealthReportMultipleItem(Object arg1) {
        return holder.format("Tasks.ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * Task Scanner: {0} open tasks found.
     * 
     */
    public static Localizable _Tasks_ResultAction_HealthReportMultipleItem(Object arg1) {
        return new Localizable(holder, "Tasks.ResultAction.HealthReportMultipleItem", arg1);
    }

    /**
     * Open tasks trend graph (priority distribution)
     * 
     */
    public static String Portlet_WarningsPriorityGraph() {
        return holder.format("Portlet.WarningsPriorityGraph");
    }

    /**
     * Open tasks trend graph (priority distribution)
     * 
     */
    public static Localizable _Portlet_WarningsPriorityGraph() {
        return new Localizable(holder, "Portlet.WarningsPriorityGraph");
    }

    /**
     *  1 closed task
     * 
     */
    public static String Tasks_ResultAction_OneFixedWarning() {
        return holder.format("Tasks.ResultAction.OneFixedWarning");
    }

    /**
     *  1 closed task
     * 
     */
    public static Localizable _Tasks_ResultAction_OneFixedWarning() {
        return new Localizable(holder, "Tasks.ResultAction.OneFixedWarning");
    }

    /**
     * Task Scanner: 1 open task found.
     * 
     */
    public static String Tasks_ResultAction_HealthReportSingleItem() {
        return holder.format("Tasks.ResultAction.HealthReportSingleItem");
    }

    /**
     * Task Scanner: 1 open task found.
     * 
     */
    public static Localizable _Tasks_ResultAction_HealthReportSingleItem() {
        return new Localizable(holder, "Tasks.ResultAction.HealthReportSingleItem");
    }

    /**
     * Task Scanner:
     * 
     */
    public static String Tasks_ResultAction_Summary() {
        return holder.format("Tasks.ResultAction.Summary");
    }

    /**
     * Task Scanner:
     * 
     */
    public static Localizable _Tasks_ResultAction_Summary() {
        return new Localizable(holder, "Tasks.ResultAction.Summary");
    }

    /**
     * New Open Tasks
     * 
     */
    public static String NewTasksDetail_Name() {
        return holder.format("NewTasksDetail.Name");
    }

    /**
     * New Open Tasks
     * 
     */
    public static Localizable _NewTasksDetail_Name() {
        return new Localizable(holder, "NewTasksDetail.Name");
    }

    /**
     * Scan workspace for open tasks
     * 
     */
    public static String Tasks_Publisher_Name() {
        return holder.format("Tasks.Publisher.Name");
    }

    /**
     * Scan workspace for open tasks
     * 
     */
    public static Localizable _Tasks_Publisher_Name() {
        return new Localizable(holder, "Tasks.Publisher.Name");
    }

    /**
     * Specified pattern is an invalid regular expression: {0}: {1}
     * 
     */
    public static String Tasks_PatternError(Object arg1, Object arg2) {
        return holder.format("Tasks.PatternError", arg1, arg2);
    }

    /**
     * Specified pattern is an invalid regular expression: {0}: {1}
     * 
     */
    public static Localizable _Tasks_PatternError(Object arg1, Object arg2) {
        return new Localizable(holder, "Tasks.PatternError", arg1, arg2);
    }

    /**
     *  1 open task
     * 
     */
    public static String Tasks_ResultAction_OneWarning() {
        return holder.format("Tasks.ResultAction.OneWarning");
    }

    /**
     *  1 open task
     * 
     */
    public static Localizable _Tasks_ResultAction_OneWarning() {
        return new Localizable(holder, "Tasks.ResultAction.OneWarning");
    }

    /**
     * {0} new open tasks
     * 
     */
    public static String Tasks_ResultAction_MultipleNewWarnings(Object arg1) {
        return holder.format("Tasks.ResultAction.MultipleNewWarnings", arg1);
    }

    /**
     * {0} new open tasks
     * 
     */
    public static Localizable _Tasks_ResultAction_MultipleNewWarnings(Object arg1) {
        return new Localizable(holder, "Tasks.ResultAction.MultipleNewWarnings", arg1);
    }

    /**
     *  1 new open task
     * 
     */
    public static String Tasks_ResultAction_OneNewWarning() {
        return holder.format("Tasks.ResultAction.OneNewWarning");
    }

    /**
     *  1 new open task
     * 
     */
    public static Localizable _Tasks_ResultAction_OneNewWarning() {
        return new Localizable(holder, "Tasks.ResultAction.OneNewWarning");
    }

    /**
     * Package
     * 
     */
    public static String Tasks_PackageDetail() {
        return holder.format("Tasks.PackageDetail");
    }

    /**
     * Package
     * 
     */
    public static Localizable _Tasks_PackageDetail() {
        return new Localizable(holder, "Tasks.PackageDetail");
    }

    /**
     * {0} open tasks
     * 
     */
    public static String Tasks_ResultAction_MultipleWarnings(Object arg1) {
        return holder.format("Tasks.ResultAction.MultipleWarnings", arg1);
    }

    /**
     * {0} open tasks
     * 
     */
    public static Localizable _Tasks_ResultAction_MultipleWarnings(Object arg1) {
        return new Localizable(holder, "Tasks.ResultAction.MultipleWarnings", arg1);
    }

}
