/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.TasksResult;

public final class ResultSummary {
    public static String createSummary(TasksResult result) {
        StringBuilder summary = new StringBuilder();
        int tasks = result.getNumberOfAnnotations();
        summary.append(Messages.Tasks_ResultAction_Summary());
        summary.append(" ");
        if (tasks > 0) {
            summary.append("<a href=\"tasksResult\">");
        }
        if (tasks == 1) {
            summary.append(Messages.Tasks_ResultAction_OneWarning());
        } else {
            summary.append(Messages.Tasks_ResultAction_MultipleWarnings((Object)tasks));
        }
        if (tasks > 0) {
            summary.append("</a>");
        }
        summary.append(" ");
        if (result.getNumberOfFiles() > 1) {
            summary.append(Messages.Tasks_ResultAction_MultipleFiles((Object)result.getNumberOfFiles()));
        } else {
            summary.append(Messages.Tasks_ResultAction_OneFile());
        }
        summary.append(".");
        return summary.toString();
    }

    public static String createDeltaMessage(TasksResult result) {
        StringBuilder summary = new StringBuilder();
        if (result.getNumberOfNewWarnings() > 0) {
            summary.append("<li><a href=\"tasksResult/new\">");
            if (result.getNumberOfNewWarnings() == 1) {
                summary.append(Messages.Tasks_ResultAction_OneNewWarning());
            } else {
                summary.append(Messages.Tasks_ResultAction_MultipleNewWarnings((Object)result.getNumberOfNewWarnings()));
            }
            summary.append("</a></li>");
        }
        if (result.getNumberOfFixedWarnings() > 0) {
            summary.append("<li><a href=\"tasksResult/fixed\">");
            if (result.getNumberOfFixedWarnings() == 1) {
                summary.append(Messages.Tasks_ResultAction_OneFixedWarning());
            } else {
                summary.append(Messages.Tasks_ResultAction_MultipleFixedWarnings((Object)result.getNumberOfFixedWarnings()));
            }
            summary.append("</a></li>");
        }
        return summary.toString();
    }

    private ResultSummary() {
    }
}

