/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.parser;

import hudson.AbortException;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.tasks.Messages;
import hudson.plugins.tasks.parser.Task;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskScanner {
    private static final String WORD_BOUNDARY = "\\b";
    private final Map<Priority, Pattern> patterns = new HashMap();
    private boolean isInvalidPattern;
    private final StringBuilder errorMessage = new StringBuilder();

    public TaskScanner() {
        this("FIXME", "TODO", "@deprecated", false);
    }

    public TaskScanner(String high, String normal, String low, boolean ignoreCase) {
        if (StringUtils.isNotBlank((String)high)) {
            this.patterns.put(Priority.HIGH, this.compile(high, ignoreCase));
        }
        if (StringUtils.isNotBlank((String)normal)) {
            this.patterns.put(Priority.NORMAL, this.compile(normal, ignoreCase));
        }
        if (StringUtils.isNotBlank((String)low)) {
            this.patterns.put(Priority.LOW, this.compile(low, ignoreCase));
        }
    }

    private Pattern compile(String tagIdentifiers, boolean ignoreCase) {
        try {
            String[] tags = tagIdentifiers.indexOf(44) == -1 ? new String[]{tagIdentifiers} : StringUtils.split((String)tagIdentifiers, (String)",");
            ArrayList<String> regexps = new ArrayList<String>();
            for (int i = 0; i < tags.length; ++i) {
                String tag = tags[i].trim();
                if (!StringUtils.isNotBlank((String)tag)) continue;
                if (Character.isLetterOrDigit(tag.charAt(0))) {
                    regexps.add(WORD_BOUNDARY + tag + WORD_BOUNDARY);
                    continue;
                }
                regexps.add(tag + WORD_BOUNDARY);
            }
            int flags = ignoreCase ? 2 : 0;
            return Pattern.compile("^.*(" + StringUtils.join(regexps.iterator(), (String)"|") + ")(.*)$", flags);
        }
        catch (PatternSyntaxException exception) {
            this.isInvalidPattern = true;
            this.errorMessage.append(Messages.Tasks_PatternError((Object)tagIdentifiers, (Object)exception.getMessage()));
            this.errorMessage.append("\n");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Task> scan(Reader reader) throws IOException {
        try {
            if (this.isInvalidPattern) {
                throw new AbortException(this.errorMessage.toString());
            }
            LineIterator lineIterator = IOUtils.lineIterator((Reader)reader);
            ArrayList<Task> tasks = new ArrayList<Task>();
            int lineNumber = 1;
            while (lineIterator.hasNext()) {
                String line = (String)lineIterator.next();
                for (Priority priority : Priority.values()) {
                    Matcher matcher;
                    if (!this.patterns.containsKey(priority) || !(matcher = ((Pattern)this.patterns.get(priority)).matcher(line)).matches() || matcher.groupCount() != 2) continue;
                    String message = matcher.group(2).trim();
                    tasks.add(new Task(priority, lineNumber, matcher.group(1), StringUtils.remove((String)message, (String)":").trim()));
                }
                ++lineNumber;
            }
            ArrayList<Task> arrayList = tasks;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }
}

