/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthAwarePublisher;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.tasks.TasksDescriptor;
import hudson.plugins.tasks.TasksProjectAction;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.plugins.tasks.parser.WorkspaceScanner;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TasksPublisher
extends HealthAwarePublisher {
    private static final long serialVersionUID = 3787892530045641806L;
    private static final String DEFAULT_PATTERN = "**/*.java";
    private final String high;
    private final String normal;
    private final String low;
    private final boolean ignoreCase;
    private final String pattern;
    private final String excludePattern;

    @DataBoundConstructor
    public TasksPublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, String high, String normal, String low, boolean ignoreCase, String pattern, String excludePattern) {
        super(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, "TASKS");
        this.pattern = pattern;
        this.excludePattern = excludePattern;
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.ignoreCase = ignoreCase;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExcludePattern() {
        return this.excludePattern;
    }

    public String getHigh() {
        return this.high;
    }

    public String getNormal() {
        return this.normal;
    }

    public String getLow() {
        return this.low;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new TasksProjectAction(project);
    }

    protected BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        logger.log("Scanning workspace files for tasks...");
        TasksParserResult project = (TasksParserResult)build.getWorkspace().act((FilePath.FileCallable)new WorkspaceScanner(StringUtils.defaultIfEmpty((String)this.getPattern(), (String)DEFAULT_PATTERN), this.getExcludePattern(), this.getDefaultEncoding(), this.high, this.normal, this.low, this.ignoreCase));
        TasksResult result = new TasksResult(build, this.getDefaultEncoding(), project, this.high, this.normal, this.low);
        build.getActions().add(new TasksResultAction(build, (HealthDescriptor)this, result));
        return result;
    }

    public TasksDescriptor getDescriptor() {
        return (TasksDescriptor)super.getDescriptor();
    }
}

