/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks.parser;

import hudson.FilePath;
import hudson.plugins.analysis.util.ContextHashCode;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.ModuleDetector;
import hudson.plugins.analysis.util.PackageDetectors;
import hudson.plugins.tasks.parser.Task;
import hudson.plugins.tasks.parser.TaskScanner;
import hudson.plugins.tasks.parser.TasksParserResult;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceScanner
implements FilePath.FileCallable<TasksParserResult> {
    private static final long serialVersionUID = -4355362392102020724L;
    private final String filePattern;
    private final String excludeFilePattern;
    private String moduleName;
    private final String high;
    private final String normal;
    private final String low;
    private final boolean ignoreCase;
    private String prefix;
    private final String defaultEncoding;

    public WorkspaceScanner(String filePattern, String excludeFilePattern, String defaultEncoding, String high, String normal, String low, boolean ignoreCase) {
        this.filePattern = filePattern;
        this.excludeFilePattern = excludeFilePattern;
        this.defaultEncoding = defaultEncoding;
        this.high = high;
        this.normal = normal;
        this.low = low;
        this.ignoreCase = ignoreCase;
    }

    public WorkspaceScanner(String filePattern, String excludeFilePattern, String defaultEncoding, String high, String normal, String low, boolean caseSensitive, String moduleName) {
        this(filePattern, excludeFilePattern, defaultEncoding, high, normal, low, caseSensitive);
        this.moduleName = moduleName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix + "/";
    }

    public String getPrefix() {
        return StringUtils.defaultIfEmpty((String)this.prefix, (String)"");
    }

    public TasksParserResult invoke(File workspace, VirtualChannel channel) throws IOException {
        String[] files = this.findFiles(workspace);
        TaskScanner taskScanner = new TaskScanner(this.high, this.normal, this.low, this.ignoreCase);
        TasksParserResult javaProject = new TasksParserResult(files.length);
        ModuleDetector moduleDetector = new ModuleDetector(workspace);
        for (String fileName : files) {
            File originalFile = new File(workspace, fileName);
            Collection tasks = taskScanner.scan((Reader)new InputStreamReader(new FilePath(originalFile).read(), EncodingValidator.defaultCharset((String)this.defaultEncoding)));
            if (tasks.isEmpty()) continue;
            String unixName = fileName.replace('\\', '/');
            String packageName = PackageDetectors.detectPackage((String)unixName, (InputStream)new FilePath(originalFile).read());
            String guessedModule = moduleDetector.guessModuleName(originalFile.getAbsolutePath());
            String actualModule = StringUtils.defaultIfEmpty((String)this.moduleName, (String)guessedModule);
            for (Task task : tasks) {
                task.setFileName(originalFile.getAbsolutePath());
                task.setPackageName(packageName);
                task.setModuleName(actualModule);
                task.setPathName(workspace.getPath());
                ContextHashCode hashCode = new ContextHashCode();
                task.setContextHashCode((long)hashCode.create(originalFile.getAbsolutePath(), task.getPrimaryLineNumber(), this.defaultEncoding));
            }
            javaProject.addAnnotations(tasks);
        }
        return javaProject;
    }

    private String[] findFiles(File workspaceRoot) {
        FileSet fileSet = new FileSet();
        Project project = new Project();
        fileSet.setProject(project);
        fileSet.setDir(workspaceRoot);
        fileSet.setIncludes(this.filePattern);
        if (StringUtils.isNotBlank((String)this.excludeFilePattern)) {
            fileSet.setExcludes(this.excludeFilePattern);
        }
        return fileSet.getDirectoryScanner(project).getIncludedFiles();
    }
}

