/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tasks;

import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.tasks.TasksResult;
import hudson.plugins.tasks.TasksResultAction;
import hudson.plugins.tasks.parser.TasksParserResult;
import java.io.IOException;

public class TasksAnnotationsAggregator
extends MatrixAggregator {
    private final TasksParserResult totals = new TasksParserResult();
    private final HealthDescriptor healthDescriptor;
    private final String defaultEncoding;
    private String highTags = "";
    private String normalTags = "";
    private String lowTags = "";

    public TasksAnnotationsAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, HealthDescriptor healthDescriptor, String defaultEncoding) {
        super(build, launcher, listener);
        this.healthDescriptor = healthDescriptor;
        this.defaultEncoding = defaultEncoding;
    }

    public boolean endRun(MatrixRun run) throws InterruptedException, IOException {
        if (this.totals.hasNoAnnotations()) {
            TasksResult result = (TasksResult)((TasksResultAction)run.getAction(TasksResultAction.class)).getResult();
            this.totals.addAnnotations(result.getAnnotations());
            this.totals.addScannedFiles(result.getNumberOfFiles());
            this.highTags = result.getTags(Priority.HIGH);
            this.normalTags = result.getTags(Priority.NORMAL);
            this.lowTags = result.getTags(Priority.LOW);
        }
        return true;
    }

    public boolean endBuild() throws InterruptedException, IOException {
        TasksResult result = new TasksResult((AbstractBuild<?, ?>)this.build, this.defaultEncoding, this.totals, this.highTags, this.normalTags, this.lowTags);
        this.build.addAction((Action)new TasksResultAction((AbstractBuild<?, ?>)this.build, this.healthDescriptor, result));
        return true;
    }
}

