/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Project;
import hudson.security.AccessControlled;
import hudson.tasks.Builder;
import hudson.tasks.Messages;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyBuilder
extends Builder {
    private final String projectName;
    public static Descriptor<Builder> DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ProxyBuilder(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Project<?, ?> getProject() {
        return (Project)Hudson.getInstance().getItem(this.projectName);
    }

    public Descriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Builder builder : this.getProject().getBuilders()) {
            if (builder.perform(build, launcher, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Builder builder : this.getProject().getBuilders()) {
            if (builder.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Builder> {
        public String getDisplayName() {
            return "Use builders from another project";
        }

        public void doCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            AccessControlled anc = (AccessControlled)req.findAncestorObject(AccessControlled.class);
            new FormFieldValidator(req, rsp, anc, Item.CONFIGURE){

                protected void check() throws IOException, ServletException {
                    String projectName = this.request.getParameter("value");
                    Item item = Hudson.getInstance().getItemByFullName(projectName, Item.class);
                    if (item == null) {
                        this.error(Messages.BuildTrigger_NoSuchProject((Object)projectName, (Object)AbstractProject.findNearest((String)projectName).getName()));
                        return;
                    }
                    if (!(item instanceof AbstractProject)) {
                        this.error(Messages.BuildTrigger_NotBuildable((Object)projectName));
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

