/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.IOException;
import javax.servlet.ServletException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyPublisher
extends Publisher {
    private final String projectName;
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public ProxyPublisher(String projectName) {
        this.projectName = projectName;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public AbstractProject<?, ?> getProject() {
        return (AbstractProject)Hudson.getInstance().getItem(this.projectName);
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public boolean prebuild(Build build, BuildListener listener) {
        for (Publisher publisher : this.getProject().getPublishersList().toList()) {
            if (publisher.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Publisher publisher : this.getProject().getPublishersList().toList()) {
            if (publisher.perform(build, launcher, listener)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends Descriptor<Publisher> {
        public String getDisplayName() {
            return "Use publishers from another project";
        }

        public void doCheck(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            AccessControlled anc = (AccessControlled)req.findAncestorObject(AccessControlled.class);
            new FormFieldValidator(req, rsp, anc, Item.CONFIGURE){

                protected void check() throws IOException, ServletException {
                    String projectName = this.request.getParameter("value");
                    Item item = Hudson.getInstance().getItemByFullName(projectName, Item.class);
                    if (item == null) {
                        this.error(Messages.BuildTrigger_NoSuchProject((Object)projectName, (Object)AbstractProject.findNearest((String)projectName).getName()));
                        return;
                    }
                    if (!(item instanceof AbstractProject)) {
                        this.error(Messages.BuildTrigger_NotBuildable((Object)projectName));
                        return;
                    }
                    this.ok();
                }
            }.process();
        }
    }
}

