/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyPublisher
extends Recorder {
    private final String projectName;

    @DataBoundConstructor
    public ProxyPublisher(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public AbstractProject<?, ?> getProject() {
        return (AbstractProject)Hudson.getInstance().getItem(this.projectName);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher publisher : this.getProject().getPublishersList().toList()) {
            if (publisher.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Publisher publisher : this.getProject().getPublishersList().toList()) {
            if (publisher.perform(build, launcher, listener)) continue;
            return false;
        }
        return true;
    }
}

