/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Launcher;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Project;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyBuilder
extends Builder {
    private final String projectName;

    @DataBoundConstructor
    public ProxyBuilder(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<Builder> getProjectBuilders() {
        AbstractProject p = (AbstractProject)Hudson.getInstance().getItem(this.projectName);
        if (p instanceof Project) {
            return ((Project)p).getBuilders();
        }
        if (p instanceof MatrixProject) {
            return ((MatrixProject)p).getBuilders();
        }
        return Collections.emptyList();
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Builder builder : this.getProjectBuilders()) {
            if (builder.perform(build, launcher, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Builder builder : this.getProjectBuilders()) {
            if (builder.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }
}

