/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.templateproject;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyPublisher
extends Recorder {
    private final String projectName;

    @DataBoundConstructor
    public ProxyPublisher(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public AbstractProject<?, ?> getProject() {
        return (AbstractProject)Hudson.getInstance().getItem(this.projectName);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        for (Publisher publisher : this.getProject().getPublishersList().toList()) {
            if (publisher.prebuild(build, listener)) continue;
            return false;
        }
        return true;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        for (Publisher publisher : this.getProject().getPublishersList().toList()) {
            if (publisher.perform(build, launcher, listener)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Use publishers from another project";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public FormValidation doCheckProjectName(@AncestorInPath AccessControlled anc, @QueryParameter String value) {
            if (!anc.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            Item item = Hudson.getInstance().getItemByFullName(value, Item.class);
            if (item == null) {
                return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject((Object)value, (Object)AbstractProject.findNearest((String)value).getName()));
            }
            if (!(item instanceof AbstractProject)) {
                return FormValidation.error((String)Messages.BuildTrigger_NotBuildable((Object)value));
            }
            return FormValidation.ok();
        }
    }
}

