/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.helpers;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Actionable;
import hudson.plugins.testabilityexplorer.report.AbstractBuildReport;
import java.io.IOException;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectAction<T extends AbstractProject<?, ?>>
extends Actionable {
    private final T m_project;

    protected AbstractProjectAction(T project) {
        this.m_project = project;
    }

    public T getProject() {
        return (T)this.m_project;
    }

    public boolean isFloatingBoxActive() {
        return false;
    }

    public boolean isGraphActive() {
        return false;
    }

    public String getGraphName() {
        return "Testabilty Trend Report";
    }

    public void doTrend(StaplerRequest request, StaplerResponse response) throws IOException {
        AbstractBuildReport action = this.getLastAction();
        if (action == null) {
            response.setStatus(404);
        } else {
            action.doTrendGraph(request, response, 100);
        }
    }

    private AbstractBuildReport getLastAction() {
        AbstractBuild lastBuild = this.getLastFinishedBuild();
        if (lastBuild != null) {
            return (AbstractBuildReport)lastBuild.getAction(AbstractBuildReport.class);
        }
        return null;
    }

    private AbstractBuild<?, ?> getLastFinishedBuild() {
        AbstractBuild lastBuild;
        for (lastBuild = (AbstractBuild)this.m_project.getLastBuild(); lastBuild != null && (lastBuild.isBuilding() || lastBuild.getAction(AbstractBuildReport.class) == null); lastBuild = (AbstractBuild)lastBuild.getPreviousBuild()) {
        }
        return lastBuild;
    }
}

