/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.parser.selectors;

import hudson.plugins.testabilityexplorer.parser.converters.ClassElementConverter;
import hudson.plugins.testabilityexplorer.parser.converters.CostElementConverter;
import hudson.plugins.testabilityexplorer.parser.converters.ElementConverter;
import hudson.plugins.testabilityexplorer.parser.converters.MethodElementConverter;
import hudson.plugins.testabilityexplorer.parser.converters.NamedConverter;
import hudson.plugins.testabilityexplorer.parser.converters.TestabilityElementConverter;
import hudson.plugins.testabilityexplorer.parser.selectors.ConverterSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultConverterSelector
implements ConverterSelector {
    static final String TAG_TESTABILITY = "testability";
    static final String TAG_CLASS = "class";
    static final String TAG_METHOD = "method";
    static final String TAG_COST = "cost";
    private List<NamedConverter> m_converters;

    public DefaultConverterSelector() {
        this.initializeConverters(new NamedConverter[]{new NamedConverter(TAG_TESTABILITY, (ElementConverter)new TestabilityElementConverter()), new NamedConverter(TAG_CLASS, (ElementConverter)new ClassElementConverter()), new NamedConverter(TAG_METHOD, (ElementConverter)new MethodElementConverter()), new NamedConverter(TAG_COST, (ElementConverter)new CostElementConverter())});
    }

    private void initializeConverters(NamedConverter ... converters) {
        this.m_converters = new ArrayList();
        this.m_converters.addAll(Arrays.asList(converters));
    }

    public ElementConverter getConverter(String elementName) {
        ElementConverter converter = null;
        if (elementName != null && elementName.length() > 0) {
            for (NamedConverter namedConverter : this.m_converters) {
                String name = namedConverter.getName();
                if (!elementName.equals(name)) continue;
                converter = namedConverter.getConverter();
                break;
            }
        }
        return converter;
    }
}

