/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.publisher;

import hudson.maven.MavenModule;
import hudson.maven.MavenReporterDescriptor;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.plugins.testabilityexplorer.helpers.ParseDelegate;
import hudson.plugins.testabilityexplorer.helpers.ReportParseDelegate;
import hudson.plugins.testabilityexplorer.parser.StatisticsParser;
import hudson.plugins.testabilityexplorer.parser.XmlStatisticsParser;
import hudson.plugins.testabilityexplorer.parser.selectors.ConverterSelector;
import hudson.plugins.testabilityexplorer.parser.selectors.DefaultConverterSelector;
import hudson.plugins.testabilityexplorer.publisher.AbstractMavenReporterImpl;
import hudson.plugins.testabilityexplorer.publisher.MavenPublisher;
import hudson.plugins.testabilityexplorer.report.CostDetailBuilder;
import hudson.plugins.testabilityexplorer.report.ProjectIndividualReport;
import hudson.plugins.testabilityexplorer.report.charts.ChartBuilder;
import hudson.plugins.testabilityexplorer.report.charts.TestabilityChartBuilder;
import hudson.plugins.testabilityexplorer.report.health.HealthCalculator;
import hudson.plugins.testabilityexplorer.report.health.ReportBuilder;
import hudson.plugins.testabilityexplorer.report.health.TemporaryHealthCalculator;
import hudson.plugins.testabilityexplorer.report.health.TestabilityReportBuilder;
import hudson.plugins.testabilityexplorer.utils.TypeConverterUtil;
import org.kohsuke.stapler.DataBoundConstructor;

public class MavenPublisher
extends AbstractMavenReporterImpl {
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl(null);
    private final String m_reportFilenamePattern;
    private final int m_threshold;

    @DataBoundConstructor
    public MavenPublisher(String reportFilenamePattern, String threshold) {
        reportFilenamePattern.getClass();
        threshold.getClass();
        this.m_reportFilenamePattern = reportFilenamePattern;
        this.m_threshold = TypeConverterUtil.toInt((String)threshold, (int)Integer.MAX_VALUE);
    }

    public Action getProjectAction(MavenModule module) {
        return new ProjectIndividualReport((AbstractProject)module);
    }

    public MavenReporterDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public ParseDelegate newParseDelegate() {
        return new ReportParseDelegate(this.m_reportFilenamePattern, this.m_threshold);
    }

    public StatisticsParser newStatisticsParser() {
        return new XmlStatisticsParser((ConverterSelector)new DefaultConverterSelector());
    }

    public CostDetailBuilder newDetailBuilder() {
        return new CostDetailBuilder();
    }

    public ReportBuilder newReportBuilder() {
        TestabilityChartBuilder chartBuilder = new TestabilityChartBuilder();
        return new TestabilityReportBuilder((ChartBuilder)chartBuilder, (HealthCalculator)new TemporaryHealthCalculator());
    }

    public String getReportFilenamePattern() {
        return this.m_reportFilenamePattern;
    }

    public int getThreshold() {
        return this.m_threshold;
    }
}

