/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report;

import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.plugins.testabilityexplorer.PluginImpl;
import hudson.plugins.testabilityexplorer.helpers.AbstractBuildAction;
import hudson.plugins.testabilityexplorer.report.CostDetailBuilder;
import hudson.plugins.testabilityexplorer.report.charts.BuildAndResults;
import hudson.plugins.testabilityexplorer.report.charts.RangedClassesTrend;
import hudson.plugins.testabilityexplorer.report.charts.RangedOverallTrend;
import hudson.plugins.testabilityexplorer.report.charts.RangedTrend;
import hudson.plugins.testabilityexplorer.report.costs.CostSummary;
import hudson.plugins.testabilityexplorer.report.costs.Statistic;
import hudson.plugins.testabilityexplorer.report.health.ReportBuilder;
import hudson.util.ChartUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildReport<T extends AbstractBuild<?, ?>>
extends AbstractBuildAction<T> {
    private final Collection<Statistic> m_results;
    private final ReportBuilder m_reportBuilder;
    private final CostDetailBuilder m_detailBuilder;

    public AbstractBuildReport(Collection<Statistic> results, ReportBuilder reportBuilder, CostDetailBuilder detailBuilder) {
        this.m_results = results;
        this.m_reportBuilder = reportBuilder;
        this.m_detailBuilder = detailBuilder;
    }

    public Collection<Statistic> getResults() {
        return this.m_results == null ? new ArrayList<Statistic>() : new ArrayList(this.m_results);
    }

    void addResults(Collection<Statistic> statistics) {
        for (Statistic statistic : statistics) {
            if (this.m_results.contains(statistic)) continue;
            this.m_results.add(statistic);
        }
    }

    public String getSummary() {
        String summary = "";
        AbstractBuild build = this.getBuild();
        if (build != null) {
            summary = " (Total: " + this.getTotals() + ")";
        }
        return summary;
    }

    public int getTotals() {
        int total = 0;
        for (Statistic statistic : this.getResults()) {
            CostSummary summary = statistic.getCostSummary();
            if (summary == null) continue;
            total += summary.getTotal();
        }
        return total;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        return this.m_detailBuilder.buildDetail(link, this.getBuild(), this.getResults());
    }

    public HealthReport getBuildHealth() {
        return this.m_reportBuilder.computeHealth(this.getResults());
    }

    public final void doTrendGraph(StaplerRequest request, StaplerResponse response, int height) throws IOException {
        if (ChartUtil.awtProblem) {
            response.sendRedirect2(request.getContextPath() + "/images/headless.png");
            return;
        }
        String classesTrend = request.getParameter("classes");
        boolean displayClassesTrend = Boolean.valueOf(StringUtils.defaultIfEmpty((String)classesTrend, (String)"false"));
        List buildsAndResults = this.retrieveExistingBuildsAndResults(this.getBuild());
        if (displayClassesTrend) {
            RangedClassesTrend rangedTrend = new RangedClassesTrend(buildsAndResults);
            JFreeChart chart = this.createChart((RangedTrend)rangedTrend);
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)800, (int)600);
        } else {
            RangedOverallTrend rangedTrend = new RangedOverallTrend(buildsAndResults);
            JFreeChart chart = this.createChart((RangedTrend)rangedTrend);
            ChartUtil.generateGraph((StaplerRequest)request, (StaplerResponse)response, (JFreeChart)chart, (int)400, (int)200);
        }
    }

    List<BuildAndResults> retrieveExistingBuildsAndResults(AbstractBuild<?, ?> startingBuild) {
        ArrayList<BuildAndResults> buildsAndResults = new ArrayList<BuildAndResults>();
        buildsAndResults.add(new BuildAndResults(startingBuild, this.getResults()));
        AbstractBuild previousBuild = this.getPreviousBuild(startingBuild);
        while (previousBuild != null) {
            AbstractBuildReport action = (AbstractBuildReport)previousBuild.getAction(this.getClass());
            if (action != null) {
                buildsAndResults.add(new BuildAndResults(previousBuild, action.getResults()));
            }
            previousBuild = this.getPreviousBuild(previousBuild);
        }
        return buildsAndResults;
    }

    JFreeChart createChart(RangedTrend rangedTrend) {
        return this.m_reportBuilder.createGraph(rangedTrend);
    }

    AbstractBuild<?, ?> getPreviousBuild(AbstractBuild<?, ?> build) {
        return (AbstractBuild)build.getPreviousBuild();
    }

    public String getGraphName() {
        return PluginImpl.GRAPH_NAME;
    }

    public String getIconFileName() {
        return PluginImpl.ICON_FILE_NAME;
    }

    public String getDisplayName() {
        return PluginImpl.DISPLAY_NAME;
    }

    public String getUrlName() {
        return PluginImpl.URL;
    }

    ReportBuilder getReportBuilder() {
        return this.m_reportBuilder;
    }

    CostDetailBuilder getDetailBuilder() {
        return this.m_detailBuilder;
    }
}

