/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report.charts;

import hudson.model.AbstractBuild;
import hudson.plugins.testabilityexplorer.report.charts.BuildAndResults;
import hudson.plugins.testabilityexplorer.report.charts.CostTemplate;
import hudson.plugins.testabilityexplorer.report.charts.RangedTrend;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.util.Collection;
import java.util.List;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangedClassesTrend
extends RangedTrend {
    public static final CostTemplate EXCELLENT_COST_TEMPLATE = new /* Unavailable Anonymous Inner Class!! */;
    public static final CostTemplate GOOD_COST_TEMPLATE = new /* Unavailable Anonymous Inner Class!! */;
    public static final CostTemplate POOR_COST_TEMPLATE = new /* Unavailable Anonymous Inner Class!! */;

    public RangedClassesTrend(List<BuildAndResults> items) {
        super(items);
    }

    public int getUpperBoundRangeAxis() {
        int maxCost = 100;
        CostTemplate[] costTemplates = new CostTemplate[]{EXCELLENT_COST_TEMPLATE, GOOD_COST_TEMPLATE, POOR_COST_TEMPLATE};
        for (BuildAndResults buildAndResults : this.getItems()) {
            Collection results = buildAndResults.getStatistics();
            for (CostTemplate costTemplate : costTemplates) {
                int cost = this.summarizeCost(results, costTemplate);
                maxCost = Math.max(maxCost, cost);
            }
        }
        return maxCost > 100 ? maxCost + 10 : maxCost;
    }

    public CategoryDataset getCategoryDataset() {
        DataSetBuilder dsb = new DataSetBuilder();
        for (BuildAndResults buildAndResults : this.getItems()) {
            AbstractBuild build = buildAndResults.getBuild();
            Collection results = buildAndResults.getStatistics();
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            dsb.add((Number)this.summarizeCost(results, EXCELLENT_COST_TEMPLATE), (Comparable)((Object)"excellent"), (Comparable)label);
            dsb.add((Number)this.summarizeCost(results, GOOD_COST_TEMPLATE), (Comparable)((Object)"good"), (Comparable)label);
            dsb.add((Number)this.summarizeCost(results, POOR_COST_TEMPLATE), (Comparable)((Object)"need work"), (Comparable)label);
        }
        return dsb.build();
    }
}

