/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report.costs;

import hudson.plugins.testabilityexplorer.report.costs.MethodCost;
import hudson.plugins.testabilityexplorer.report.costs.TestabilityCost;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCost
implements Serializable,
TestabilityCost {
    private String m_name;
    private int m_cost;
    private Collection<MethodCost> m_costStack;

    public ClassCost(String name, int cost) {
        this.m_name = name;
        this.m_cost = cost;
    }

    public void addToCostStack(MethodCost methodTestability) {
        if (this.m_costStack == null) {
            this.m_costStack = new ArrayList();
        }
        this.m_costStack.add(methodTestability);
    }

    public String getName() {
        return this.m_name;
    }

    public int getCost() {
        return this.m_cost;
    }

    public Collection<MethodCost> getCostStack() {
        return Collections.unmodifiableCollection(this.m_costStack);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.m_name != null) {
            sb.append("Name: " + this.m_name + ", ");
        }
        sb.append("Cost: " + this.m_cost);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassCost classCost = (ClassCost)o;
        return !(this.m_name != null ? !this.m_name.equals(classCost.m_name) : classCost.m_name != null);
    }

    public int hashCode() {
        return this.m_name != null ? this.m_name.hashCode() : 0;
    }
}

