/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report.costs;

import hudson.plugins.testabilityexplorer.report.costs.TestabilityCost;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodCost
implements Serializable,
TestabilityCost {
    private String m_name;
    private int m_cyclomatic;
    private int m_global;
    private int m_line;
    private int m_lod;
    private int m_overall;
    private String m_reason;
    private Collection<MethodCost> m_costStack;

    public MethodCost(String name, int cyclomatic, int global, int line, int lod, int overall, String reason) {
        this.m_name = name;
        this.m_cyclomatic = cyclomatic;
        this.m_global = global;
        this.m_line = line;
        this.m_lod = lod;
        this.m_overall = overall;
        this.m_reason = reason;
    }

    public void addToCostStack(MethodCost methodTestability) {
        if (this.m_costStack == null) {
            this.m_costStack = new ArrayList();
        }
        this.m_costStack.add(methodTestability);
    }

    public int getSubCostSize() {
        return this.getCostStack().size();
    }

    public String getName() {
        return this.m_name == null ? "" : this.m_name;
    }

    public int getCyclomatic() {
        return this.m_cyclomatic;
    }

    public int getGlobal() {
        return this.m_global;
    }

    public int getLine() {
        return this.m_line;
    }

    public int getLod() {
        return this.m_lod;
    }

    public int getOverall() {
        return this.m_overall;
    }

    public String getReason() {
        return this.m_reason == null ? "" : this.m_reason;
    }

    public Collection<MethodCost> getCostStack() {
        return this.m_costStack == null ? new ArrayList() : Collections.unmodifiableCollection(this.m_costStack);
    }
}

