/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report.health;

import hudson.model.HealthReport;
import hudson.plugins.testabilityexplorer.report.charts.ChartBuilder;
import hudson.plugins.testabilityexplorer.report.costs.CostSummary;
import hudson.plugins.testabilityexplorer.report.costs.Statistic;
import hudson.plugins.testabilityexplorer.report.health.DrawingReportBuilder;
import hudson.plugins.testabilityexplorer.report.health.HealthCalculator;
import hudson.plugins.testabilityexplorer.report.health.TemporaryHealthCalculator;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestabilityReportBuilder
extends DrawingReportBuilder {
    private final HealthCalculator m_healthCalculator;

    public TestabilityReportBuilder(ChartBuilder chartBuilder, HealthCalculator healthCalculator) {
        super(chartBuilder);
        this.m_healthCalculator = healthCalculator;
    }

    public HealthReport computeHealth(Collection<Statistic> results) {
        int score;
        String description = "";
        int allClasses = 0;
        int excellentClasses = 0;
        for (Statistic result : results) {
            allClasses += this.getNumberOfClasses(result.getCostSummary());
            excellentClasses += this.getNumberOfExcellentClasses(result.getCostSummary());
        }
        HealthCalculator healthCalculator = this.m_healthCalculator;
        if (this.m_healthCalculator == null) {
            healthCalculator = new TemporaryHealthCalculator();
        }
        description = (score = healthCalculator.calculate(allClasses, excellentClasses, 0, 0)) == 100 ? "Testability is excellent." : (score > 80 ? "Testability almost excellent." : (score > 0 ? "Testability need to be improved." : "Testability is awful."));
        return new HealthReport(score, description);
    }

    private int getNumberOfClasses(CostSummary costSummary) {
        return costSummary.getExcellent() + costSummary.getGood() + costSummary.getNeedsWork();
    }

    private int getNumberOfExcellentClasses(CostSummary costSummary) {
        return costSummary.getExcellent();
    }
}

