/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.helpers;

import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testabilityexplorer.helpers.BuildProxy;
import hudson.plugins.testabilityexplorer.helpers.ParseDelegate;
import hudson.plugins.testabilityexplorer.parser.StatisticsParser;
import hudson.plugins.testabilityexplorer.report.BuildIndividualReport;
import hudson.plugins.testabilityexplorer.report.costs.Statistic;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportParseDelegate
implements ParseDelegate {
    private final String m_reportFilenamePattern;
    private final int m_threshold;

    public ReportParseDelegate(String reportFilenamePattern, int threshold) {
        this.m_reportFilenamePattern = reportFilenamePattern;
        this.m_threshold = threshold;
    }

    @Override
    public boolean perform(BuildProxy build, BuildListener listener) {
        List<FilePath> filesToParse = this.getFilesToParse(build);
        Collection<Statistic> results = null;
        for (FilePath filePath : filesToParse) {
            String pathStr = filePath.getRemote();
            StatisticsParser parser = build.getStatisticsParser();
            results = parser.parse(new File(pathStr));
        }
        boolean successful = this.isSuccessful(results);
        this.flagBuild(this.isSuccessful(results), build);
        build.addAction(new BuildIndividualReport(results, build.getReportBuilder(), build.getDetailBuilder()));
        return successful;
    }

    protected void flagBuild(boolean successful, BuildProxy build) {
        if (!successful) {
            build.setResult(Result.UNSTABLE);
        }
    }

    protected List<FilePath> getFilesToParse(BuildProxy build) {
        FilePath[] paths;
        try {
            paths = build.getModuleRoot().list(this.m_reportFilenamePattern);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get report files using the specified report file pattern (" + this.m_reportFilenamePattern + ").");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unable to get report files using the specified report file pattern (" + this.m_reportFilenamePattern + ").");
        }
        ArrayList<FilePath> filesToParse = new ArrayList<FilePath>();
        for (FilePath path : paths) {
            if (filesToParse.contains(path)) continue;
            filesToParse.add(path);
        }
        return filesToParse;
    }

    private boolean isSuccessful(Collection<Statistic> results) {
        boolean successful;
        block1: {
            Statistic result;
            int total;
            successful = true;
            if (results == null) break block1;
            Iterator<Statistic> i$ = results.iterator();
            while (i$.hasNext() && (successful = (total = (result = i$.next()).getCostSummary().getTotal()) <= this.m_threshold)) {
            }
        }
        return successful;
    }
}

