/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.helpers;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testabilityexplorer.helpers.AbstractBuildAction;
import hudson.plugins.testabilityexplorer.helpers.BuildProxyCallableHelper;
import hudson.plugins.testabilityexplorer.helpers.ParseDelegate;
import hudson.plugins.testabilityexplorer.parser.StatisticsParser;
import hudson.plugins.testabilityexplorer.report.CostDetailBuilder;
import hudson.plugins.testabilityexplorer.report.health.ReportBuilder;
import hudson.remoting.Callable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BuildProxy {
    private final FilePath m_moduleRoot;
    private final StatisticsParser m_statisticsParser;
    private final CostDetailBuilder m_detailBuilder;
    private final ReportBuilder m_reportBuilder;
    private final List<AbstractBuildAction<AbstractBuild<?, ?>>> m_actions = new ArrayList();
    private Result m_result = null;

    public BuildProxy(FilePath moduleRoot, StatisticsParser statisticsParser, CostDetailBuilder detailBuilder, ReportBuilder reportBuilder) {
        this.m_moduleRoot = moduleRoot;
        this.m_statisticsParser = statisticsParser;
        this.m_detailBuilder = detailBuilder;
        this.m_reportBuilder = reportBuilder;
    }

    public boolean doPerform(ParseDelegate parseDelegate, AbstractBuild<?, ?> build, BuildListener listener) {
        BuildProxyCallableHelper callableHelper = new BuildProxyCallableHelper(this, parseDelegate, listener);
        BuildProxy buildProxy = null;
        try {
            buildProxy = (BuildProxy)this.getModuleRoot().act((Callable)callableHelper);
            buildProxy.updateBuild(build);
        }
        catch (Throwable e) {
            if (buildProxy != null) {
                buildProxy.setResult(Result.FAILURE);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public FilePath getModuleRoot() {
        return this.m_moduleRoot;
    }

    public StatisticsParser getStatisticsParser() {
        return this.m_statisticsParser;
    }

    public CostDetailBuilder getDetailBuilder() {
        return this.m_detailBuilder;
    }

    public ReportBuilder getReportBuilder() {
        return this.m_reportBuilder;
    }

    public Result getResult() {
        return this.m_result;
    }

    public void setResult(Result result) {
        this.m_result = result;
    }

    public void updateBuild(AbstractBuild<?, ?> build) {
        for (AbstractBuildAction<AbstractBuild<?, ?>> action : this.m_actions) {
            if (build.getActions().contains(action)) continue;
            action.setBuild(build);
            build.getActions().add(action);
        }
        Result result = this.getResult();
        build.setResult(result == null ? Result.SUCCESS : result);
    }

    public void addAction(AbstractBuildAction<AbstractBuild<?, ?>> abstractBuildAction) {
        this.m_actions.add(abstractBuildAction);
    }
}

