/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.parser;

import hudson.plugins.testabilityexplorer.parser.StatisticsParser;
import hudson.plugins.testabilityexplorer.parser.converters.ElementConverter;
import hudson.plugins.testabilityexplorer.parser.selectors.ConverterSelector;
import hudson.plugins.testabilityexplorer.report.costs.CostSummary;
import hudson.plugins.testabilityexplorer.report.costs.Statistic;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlStatisticsParser
extends StatisticsParser {
    private ConverterSelector m_converterSelector = null;

    public XmlStatisticsParser(ConverterSelector converterSelector) {
        this.m_converterSelector = converterSelector;
    }

    @Override
    public Collection<Statistic> parse(File inFile) {
        ArrayList<Statistic> statistics = new ArrayList();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(inFile);
            statistics = this.parse(fileInputStream);
        }
        catch (FileNotFoundException e) {
            try {
                String filePath = inFile != null ? inFile.getPath() : "";
                throw new IllegalStateException("Unable to find input file (" + filePath + ").", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return statistics;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<Statistic> parse(InputStream inputStream) {
        ArrayList<Statistic> results = new ArrayList<Statistic>();
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(inputStream);
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput((InputStream)bufferedInputStream, null);
            CostSummary overallCost = this.processRootElement(xpp);
            results.add(new Statistic(overallCost));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Unable to process report file.", e);
                catch (XmlPullParserException e2) {
                    throw new IllegalStateException("Unable to parse report file.", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        this.sortByCost(results);
        return results;
    }

    private void sortByCost(Collection<Statistic> results) {
        for (Statistic result : results) {
            result.sort();
        }
    }

    protected CostSummary processRootElement(XmlPullParser xpp) throws IOException, XmlPullParserException {
        CostSummary overallCost = null;
        int eventType = xpp.getEventType();
        do {
            if (eventType != 2) continue;
            String elementName = xpp.getName();
            ElementConverter converter = this.m_converterSelector.getConverter(elementName);
            if (converter == null) {
                throw new IllegalStateException("The " + this.m_converterSelector.getClass().getSimpleName() + " was unable to return a ElementConverter for XML tag name: " + elementName);
            }
            if (overallCost == null) {
                overallCost = (CostSummary)converter.construct(xpp, null);
                continue;
            }
            converter.construct(xpp, overallCost);
        } while ((eventType = xpp.next()) != 1);
        return overallCost;
    }
}

