/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.publisher;

import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.testabilityexplorer.helpers.BuildProxy;
import hudson.plugins.testabilityexplorer.helpers.ParseDelegate;
import hudson.plugins.testabilityexplorer.publisher.ExtractAndBuildDelegate;
import java.io.IOException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenReporterImpl
extends MavenReporter
implements ExtractAndBuildDelegate {
    public boolean postBuild(MavenBuildProxy build, MavenProject pom, BuildListener listener) throws InterruptedException, IOException {
        try {
            build.execute(this.getBuildCallable(listener));
        }
        catch (Throwable e) {
            build.setResult(Result.FAILURE);
            return false;
        }
        return true;
    }

    MavenBuildProxy.BuildCallable<Void, IOException> getBuildCallable(final BuildListener listener) {
        return new MavenBuildProxy.BuildCallable<Void, IOException>(){

            public Void call(MavenBuild mavenBuild) throws IOException {
                if (mavenBuild.isBuilding()) {
                    AbstractProject project = mavenBuild.getProject();
                    BuildProxy buildProxy = new BuildProxy(AbstractMavenReporterImpl.this.getModuleRoot(project), AbstractMavenReporterImpl.this.newStatisticsParser(), AbstractMavenReporterImpl.this.newDetailBuilder(), AbstractMavenReporterImpl.this.newReportBuilder());
                    ParseDelegate parseDelegate = AbstractMavenReporterImpl.this.newParseDelegate();
                    parseDelegate.perform(buildProxy, listener);
                    buildProxy.updateBuild((AbstractBuild<?, ?>)mavenBuild);
                }
                return null;
            }
        };
    }

    FilePath getModuleRoot(AbstractProject project) {
        return project.getModuleRoot();
    }
}

