/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.publisher;

import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.plugins.testabilityexplorer.helpers.ParseDelegate;
import hudson.plugins.testabilityexplorer.helpers.ReportParseDelegate;
import hudson.plugins.testabilityexplorer.parser.StatisticsParser;
import hudson.plugins.testabilityexplorer.parser.XmlStatisticsParser;
import hudson.plugins.testabilityexplorer.parser.selectors.DefaultConverterSelector;
import hudson.plugins.testabilityexplorer.publisher.AbstractPublisherImpl;
import hudson.plugins.testabilityexplorer.publisher.TestabilityExplorerDescriptor;
import hudson.plugins.testabilityexplorer.report.CostDetailBuilder;
import hudson.plugins.testabilityexplorer.report.ProjectIndividualReport;
import hudson.plugins.testabilityexplorer.report.charts.TestabilityChartBuilder;
import hudson.plugins.testabilityexplorer.report.health.ReportBuilder;
import hudson.plugins.testabilityexplorer.report.health.TemporaryHealthCalculator;
import hudson.plugins.testabilityexplorer.report.health.TestabilityReportBuilder;
import hudson.plugins.testabilityexplorer.utils.TypeConverterUtil;
import hudson.tasks.Publisher;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreestylePublisher
extends AbstractPublisherImpl {
    public static final Descriptor DESCRIPTOR = new TestabilityExplorerDescriptor();
    private final String m_reportFilenamePattern;
    private final int m_threshold;
    private final int m_perClassThreshold;

    @DataBoundConstructor
    public FreestylePublisher(String reportFilenamePattern, String threshold, String perClassThreshold) {
        this.m_reportFilenamePattern = reportFilenamePattern;
        this.m_threshold = this.toInt(threshold, Integer.MAX_VALUE);
        this.m_perClassThreshold = this.toInt(perClassThreshold, Integer.MAX_VALUE);
    }

    protected int toInt(String value, int defaultValue) {
        return TypeConverterUtil.toInt(value, defaultValue);
    }

    @Override
    public ParseDelegate newParseDelegate() {
        return new ReportParseDelegate(this.getReportFilenamePattern(), this.getThreshold(), this.getPerClassThreshold());
    }

    @Override
    public StatisticsParser newStatisticsParser() {
        return new XmlStatisticsParser(new DefaultConverterSelector());
    }

    @Override
    public CostDetailBuilder newDetailBuilder() {
        return new CostDetailBuilder();
    }

    @Override
    public ReportBuilder newReportBuilder() {
        TestabilityChartBuilder chartBuilder = new TestabilityChartBuilder();
        return new TestabilityReportBuilder(chartBuilder, new TemporaryHealthCalculator());
    }

    public String getReportFilenamePattern() {
        return this.m_reportFilenamePattern;
    }

    public int getThreshold() {
        return this.m_threshold;
    }

    public int getPerClassThreshold() {
        return this.m_perClassThreshold;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public Action getProjectAction(Project project) {
        return new ProjectIndividualReport((AbstractProject<?, ?>)project);
    }
}

