/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import hudson.plugins.testabilityexplorer.PluginImpl;
import hudson.plugins.testabilityexplorer.helpers.AbstractProjectAction;
import hudson.plugins.testabilityexplorer.report.AbstractBuildReport;
import hudson.plugins.testabilityexplorer.report.costs.Statistic;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectReport<T extends AbstractProject<?, ?>>
extends AbstractProjectAction<T>
implements ProminentProjectAction {
    public AbstractProjectReport(T project) {
        super(project);
    }

    public String getIconFileName() {
        AbstractBuildReport action = this.getApplicableBuildAction();
        return action != null ? PluginImpl.ICON_FILE_NAME : null;
    }

    public String getDisplayName() {
        AbstractBuildReport action = this.getApplicableBuildAction();
        return action != null ? PluginImpl.DISPLAY_NAME : null;
    }

    public String getUrlName() {
        AbstractBuildReport action = this.getApplicableBuildAction();
        return action != null ? PluginImpl.URL : null;
    }

    public String getSearchUrl() {
        return PluginImpl.URL;
    }

    public Collection<Statistic> getResults() {
        AbstractBuildReport action = this.getApplicableBuildAction();
        return action != null ? action.getResults() : Collections.emptySet();
    }

    public int getTotals() {
        AbstractBuildReport action = this.getApplicableBuildAction();
        return action != null ? action.getTotals() : 0;
    }

    protected AbstractBuildReport getApplicableBuildAction() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action;
        }
        return null;
    }

    protected abstract Class<? extends AbstractBuildReport> getBuildActionClass();
}

