/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report;

import hudson.model.AbstractBuild;
import hudson.plugins.testabilityexplorer.report.DetailBuilder;
import hudson.plugins.testabilityexplorer.report.costs.ClassCost;
import hudson.plugins.testabilityexplorer.report.costs.CostSummary;
import hudson.plugins.testabilityexplorer.report.costs.MethodCost;
import hudson.plugins.testabilityexplorer.report.costs.Statistic;
import hudson.plugins.testabilityexplorer.report.detail.ClassCostDetail;
import hudson.plugins.testabilityexplorer.report.detail.MethodCostDetail;
import hudson.plugins.testabilityexplorer.utils.TypeConverterUtil;
import java.util.Collection;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CostDetailBuilder
implements DetailBuilder<Statistic> {
    private static final Pattern LINE_PATTERN = Pattern.compile("\\:line\\.([\\d]*)[\\/]?\\Z", 32);

    @Override
    public Object buildDetail(String link, String originalRequestUri, AbstractBuild<?, ?> build, Collection<Statistic> statistics) {
        Object dynamic = null;
        if (!StringUtils.isBlank((String)link) && link.startsWith("class.")) {
            String className = StringUtils.substringAfter((String)link, (String)"class.");
            if (className.contains(":")) {
                className = StringUtils.substringBefore((String)className, (String)":");
            }
            if (!StringUtils.isBlank((String)className)) {
                block0: for (Statistic statistic : statistics) {
                    CostSummary summary = statistic.getCostSummary();
                    for (ClassCost classCost : summary.getCostStack()) {
                        if (!className.equals(classCost.getName())) continue;
                        ClassCostDetail classCostDetail = new ClassCostDetail();
                        classCostDetail.setOwner(build);
                        classCostDetail.setClassCost(classCost);
                        dynamic = classCostDetail;
                        MethodCost methodCost = this.lookupMethodCost(classCost, originalRequestUri);
                        if (methodCost == null) continue block0;
                        MethodCostDetail methodCostDetail = new MethodCostDetail();
                        methodCostDetail.setMethodCost(methodCost);
                        methodCostDetail.setOwner(build);
                        dynamic = methodCostDetail;
                        continue block0;
                    }
                }
            }
        }
        return dynamic;
    }

    MethodCost lookupMethodCost(ClassCost classCost, String originalRequestUri) {
        String lineNumber;
        MethodCost cost = null;
        if (!StringUtils.isBlank((String)originalRequestUri) && (lineNumber = this.findMatch(originalRequestUri)) != null) {
            int line = TypeConverterUtil.toInt(lineNumber, -1);
            for (MethodCost methodCost : classCost.getCostStack()) {
                if (methodCost.getLine() != line) continue;
                cost = methodCost;
                break;
            }
        }
        return cost;
    }

    String findMatch(String originalRequestUri) {
        String match;
        block0: {
            match = null;
            Matcher m = LINE_PATTERN.matcher(originalRequestUri);
            if (!m.find()) break block0;
            MatchResult matchResult = m.toMatchResult();
            match = matchResult.group(1);
        }
        return match;
    }
}

