/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testabilityexplorer.report.charts;

import hudson.model.AbstractBuild;
import hudson.plugins.testabilityexplorer.report.charts.BuildAndResults;
import hudson.plugins.testabilityexplorer.report.charts.CostTemplate;
import hudson.plugins.testabilityexplorer.report.charts.RangedTrend;
import hudson.plugins.testabilityexplorer.report.costs.Statistic;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.util.Collection;
import java.util.List;
import org.jfree.data.category.CategoryDataset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangedOverallTrend
extends RangedTrend {
    public static final CostTemplate TOTAL_COST_TEMPLATE = new CostTemplate(){

        public int getCost(Statistic statistic) {
            return statistic.getCostSummary().getTotal();
        }
    };

    public RangedOverallTrend(List<BuildAndResults> items) {
        super(items);
    }

    @Override
    public int getUpperBoundRangeAxis() {
        int maxCost = 100;
        CostTemplate totalCostTemplate = TOTAL_COST_TEMPLATE;
        for (BuildAndResults buildAndResults : this.getItems()) {
            Collection<Statistic> results = buildAndResults.getStatistics();
            int totalCost = this.summarizeCost(results, totalCostTemplate);
            maxCost = Math.max(maxCost, totalCost);
        }
        return maxCost > 100 ? maxCost + 10 : maxCost;
    }

    @Override
    public CategoryDataset getCategoryDataset() {
        DataSetBuilder dsb = new DataSetBuilder();
        CostTemplate totalCostTemplate = TOTAL_COST_TEMPLATE;
        Collection<Statistic> previousNonEmptyResults = null;
        for (BuildAndResults buildAndResults : this.getItems()) {
            AbstractBuild<?, ?> build = buildAndResults.getBuild();
            Collection<Statistic> results = buildAndResults.getStatistics();
            if (results.isEmpty()) {
                results = previousNonEmptyResults != null ? previousNonEmptyResults : results;
            } else {
                previousNonEmptyResults = results;
            }
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            dsb.add((Number)this.summarizeCost(results, totalCostTemplate), (Comparable)((Object)"overall"), (Comparable)label);
        }
        return dsb.build();
    }
}

