/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.helpers.BuildProxy;
import hudson.plugins.helpers.Ghostwriter;
import hudson.plugins.testng.BuildIndividualReport;
import hudson.plugins.testng.parser.ResultsParser;
import hudson.plugins.testng.results.TestResults;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GhostWriter
implements Ghostwriter,
Ghostwriter.MasterGhostwriter,
Ghostwriter.SlaveGhostwriter {
    private final String reportFilenamePattern;

    public GhostWriter(String reportFilenamePattern) {
        this.reportFilenamePattern = reportFilenamePattern;
    }

    public boolean performFromMaster(AbstractBuild<?, ?> build, FilePath executionRoot, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public boolean performFromSlave(BuildProxy build, BuildListener listener) throws InterruptedException, IOException {
        FilePath[] paths = build.getExecutionRootDir().list(this.reportFilenamePattern);
        Collection results = null;
        HashSet<String> parsedFiles = new HashSet<String>();
        for (FilePath path : paths) {
            String pathStr = path.getRemote();
            if (parsedFiles.contains(pathStr)) continue;
            parsedFiles.add(pathStr);
            Collection result = ResultsParser.parse((File)new File(pathStr), (PrintStream)listener.getLogger());
            if (results == null) {
                results = result;
                continue;
            }
            results.addAll(result);
        }
        if (results != null) {
            BuildIndividualReport action = new BuildIndividualReport(results);
            build.getActions().add(action);
            TestResults r = TestResults.total((Collection[])new Collection[]{results});
            if (r.getFailedConfigurationMethodsCount() > 0 || r.getSkippedConfigurationMethodsCount() > 0 || r.getFailedTestCount() > 0 || r.getSkippedTestCount() > 0) {
                build.setResult(Result.UNSTABLE);
            }
        }
        return true;
    }
}

