/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.MethodResult;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResult
extends BaseResult
implements ModelObject {
    private List<MethodResult> testMethodList = new ArrayList();
    private long duration;
    private int fail;
    private int skip;
    private int total;

    public String getUrl() {
        return this.getName();
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        super.setOwner(owner);
        for (MethodResult _m : this.testMethodList) {
            _m.setOwner(owner);
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getFail() {
        return this.fail;
    }

    public void setFail(int fail) {
        this.fail = fail;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setTestMethodList(List<MethodResult> testMethodList) {
        this.testMethodList = testMethodList;
    }

    public void tally() {
        this.duration = 0L;
        this.fail = 0;
        this.skip = 0;
        this.total = this.testMethodList.size();
        for (MethodResult _m : this.testMethodList) {
            this.duration += _m.getDuration();
            if ("FAIL".equals(_m.getStatus())) {
                ++this.fail;
            } else if ("SKIP".equals(_m.getStatus())) {
                ++this.skip;
            }
            _m.setParent((BaseResult)this);
        }
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals("/" + this.getName())) {
            return this;
        }
        if (this.testMethodList != null) {
            for (MethodResult testNGMethod : this.testMethodList) {
                if (!token.equals(testNGMethod.getName())) continue;
                return testNGMethod;
            }
        }
        return null;
    }

    public List<MethodResult> getTestMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }

    public List<MethodResult> getConfigurationMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (!methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }
}

