/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.helpers.BuildProxy;
import hudson.plugins.helpers.Ghostwriter;
import java.io.IOException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractMavenReporterImpl
extends MavenReporter {
    protected MojoExecutionReportingMode getExecutionMode() {
        return MojoExecutionReportingMode.ONLY_REPORT_ON_SUCCESS;
    }

    public boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        if (!this.isExecutingMojo(mojo)) {
            return true;
        }
        Boolean okToContinue = this.getExecutionMode().isOkToContinue(this, build, listener, error);
        if (okToContinue != null) {
            return okToContinue;
        }
        build.registerAsProjectAction((MavenReporter)this);
        return BuildProxy.doPerform(this.newGhostwriter(pom, mojo), build, pom, listener);
    }

    protected abstract boolean isExecutingMojo(MojoInfo var1);

    protected abstract Ghostwriter newGhostwriter(MavenProject var1, MojoInfo var2);

    public boolean preExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) throws InterruptedException, IOException {
        return !this.isAutoconfMojo(mojo) || this.autoconfPom(build, pom, mojo, listener);
    }

    protected boolean autoconfPom(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener) {
        return true;
    }

    protected boolean isAutoconfMojo(MojoInfo mojo) {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum MojoExecutionReportingMode {
        ONLY_REPORT_ON_SUCCESS{

            Boolean isOkToContinue(MavenReporter reporter, MavenBuildProxy build, BuildListener listener, Throwable error) {
                return error == null ? null : Boolean.TRUE;
            }
        }
        ,
        ALWAYS_REPORT_STABLE{

            Boolean isOkToContinue(MavenReporter reporter, MavenBuildProxy build, BuildListener listener, Throwable error) {
                return null;
            }
        }
        ,
        REPORT_UNSTABLE_ON_ERROR{

            Boolean isOkToContinue(MavenReporter reporter, MavenBuildProxy build, BuildListener listener, Throwable error) {
                if (error != null) {
                    listener.getLogger().println("[HUDSON] " + reporter.getDescriptor().getDisplayName() + " setting build to UNSTABLE");
                    build.setResult(Result.UNSTABLE);
                }
                return null;
            }
        };


        abstract Boolean isOkToContinue(MavenReporter var1, MavenBuildProxy var2, BuildListener var3, Throwable var4);
    }
}

