/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import hudson.plugins.helpers.AbstractProjectAction;
import hudson.plugins.helpers.GraphHelper;
import hudson.plugins.testng.AbstractBuildReport;
import hudson.plugins.testng.PluginImpl;
import hudson.plugins.testng.results.TestResults;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectReport<T extends AbstractProject<?, ?>>
extends AbstractProjectAction<T>
implements ProminentProjectAction {
    public AbstractProjectReport(T project) {
        super(project);
    }

    public String getIconFileName() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return PluginImpl.ICON_FILE_NAME;
        }
        return null;
    }

    public String getDisplayName() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            TestResults testResults;
            AbstractBuild lastBuild;
            AbstractBuildReport lastActions;
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            String displayName = PluginImpl.DISPLAY_NAME + " ";
            if (this.getProject().getLastBuild() != null && (lastActions = (AbstractBuildReport)(lastBuild = (AbstractBuild)this.getProject().getLastBuild()).getAction(this.getBuildActionClass())) != null && (testResults = action.getResults()) != null) {
                if (this.getResults().getPassedTestCount() > 0) {
                    displayName = displayName + "<br/>" + this.getResults().getPassedTestCount() + " Tests Passed ";
                }
                if (this.getResults().getFailedTestCount() > 0) {
                    displayName = displayName + "<br/>" + this.getResults().getFailedTestCount() + " Tests Failed ";
                }
                if (this.getResults().getSkippedTestCount() > 0) {
                    displayName = displayName + "<br/>" + this.getResults().getSkippedTestCount() + " Tests Skipped ";
                }
            }
            return displayName;
        }
        return null;
    }

    @Override
    public String getGraphName() {
        return PluginImpl.GRAPH_NAME;
    }

    public String getUrlName() {
        AbstractBuild lastCompletedBuild = (AbstractBuild)this.getProject().getLastCompletedBuild();
        if (lastCompletedBuild != null) {
            return "lastCompletedBuild/" + PluginImpl.URL;
        }
        return null;
    }

    public String getSearchUrl() {
        return PluginImpl.URL;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (GraphHelper.isGraphUnsupported()) {
            GraphHelper.redirectWhenGraphUnsupported(rsp, req);
            return;
        }
        Calendar t = ((AbstractBuild)this.getProject().getLastBuild()).getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.buildChart(dataSetBuilder.build()), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    @Override
    public boolean isGraphActive() {
        AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = (AbstractBuild)build.getPreviousBuild();
        }
        return true;
    }

    public TestResults getResults() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action.getResults();
        }
        return null;
    }

    protected abstract Class<? extends AbstractBuildReport> getBuildActionClass();

    protected void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            dataset.add((Number)action.getResults().getPassedTestCount(), (Comparable)((Object)"Passed"), (Comparable)label);
            dataset.add((Number)action.getResults().getFailedTestCount(), (Comparable)((Object)"Failed"), (Comparable)label);
            dataset.add((Number)action.getResults().getSkippedTestCount(), (Comparable)((Object)"Skipped"), (Comparable)label);
        }
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

