/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.parser;

import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.MethodResultException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultPullParserHelper {
    private static final Logger log = Logger.getLogger(ResultPullParserHelper.class.getName());

    public boolean parseToTagIfFound(XmlPullParser xmlPullParser, String name, int initialDepth) {
        if (xmlPullParser != null && name != null) {
            try {
                while (xmlPullParser.getDepth() >= initialDepth) {
                    if (this.isStartTag(xmlPullParser)) {
                        log.info("current node name : " + xmlPullParser.getName());
                        if (name.equals(xmlPullParser.getName())) {
                            return true;
                        }
                    }
                    xmlPullParser.next();
                }
            }
            catch (XmlPullParserException e) {
                log.info("next() threw exception : " + e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public String parseToTagIfAnyFound(XmlPullParser xmlPullParser, List<String> tags, int initialDepth) {
        if (xmlPullParser != null && tags != null && tags.size() > 0) {
            try {
                while (xmlPullParser.getDepth() >= initialDepth) {
                    if (this.isStartTag(xmlPullParser)) {
                        log.info("current node name : " + xmlPullParser.getName());
                        if (tags.contains(xmlPullParser.getName())) {
                            return xmlPullParser.getName();
                        }
                    }
                    xmlPullParser.next();
                }
            }
            catch (XmlPullParserException e) {
                log.info("next() threw exception : " + e.getMessage());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public MethodResult createTestMethod(XmlPullParser xmlPullParser, ClassResult testNGClass) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        MethodResult testNGTestMethod = null;
        if (xmlPullParser != null) {
            testNGTestMethod = new MethodResult();
            testNGTestMethod.setName(xmlPullParser.getAttributeValue(null, "name"));
            testNGTestMethod.setStatus(xmlPullParser.getAttributeValue(null, "status"));
            testNGTestMethod.setDescription(xmlPullParser.getAttributeValue(null, "description"));
            try {
                testNGTestMethod.setDuration(Long.parseLong(xmlPullParser.getAttributeValue(null, "duration-ms")));
            }
            catch (NumberFormatException e) {
                log.info("unable to obtain duration-ms");
            }
            try {
                testNGTestMethod.setStartedAt(simpleDateFormat.parse(xmlPullParser.getAttributeValue(null, "started-at")));
            }
            catch (ParseException e) {
                log.info("unable to obtain started-at");
            }
            String isConfigStr = xmlPullParser.getAttributeValue(null, "is-config");
            testNGTestMethod.setFullName(testNGClass.getFullName() + "." + testNGTestMethod.getName());
            if (isConfigStr == null) {
                testNGTestMethod.setConfig(false);
            } else {
                testNGTestMethod.setConfig(true);
            }
        }
        this.printTestMethod(testNGTestMethod);
        return testNGTestMethod;
    }

    public void printTestMethod(MethodResult testMethod) {
        if (testMethod != null) {
            log.info("name : " + testMethod.getName());
            log.info("duration : " + testMethod.getDuration());
            log.info("name : " + testMethod.getException());
            log.info("status : " + testMethod.getStatus());
            log.info("description : " + testMethod.getDescription());
            log.info("startedAt : " + testMethod.getStartedAt());
            if (testMethod.getException() != null) {
                log.info("exceptionMessage : " + testMethod.getException().getMessage());
            }
        } else {
            log.info("testMethod is null");
        }
    }

    public MethodResultException createExceptionObject(XmlPullParser xmlPullParser) {
        MethodResultException exception = new MethodResultException();
        if (xmlPullParser != null && this.parseToTagIfFound(xmlPullParser, "exception", xmlPullParser.getDepth())) {
            ArrayList<String> tags = new ArrayList<String>();
            tags.add("message");
            tags.add("short-stacktrace");
            tags.add("full-stacktrace");
            int exceptionDepth = xmlPullParser.getDepth();
            while (tags.size() > 0) {
                String tagFound = this.parseToTagIfAnyFound(xmlPullParser, tags, exceptionDepth);
                if (tagFound == null) {
                    log.info("did not find any of the tags. break from the loop");
                    break;
                }
                try {
                    if (tagFound.equals("message")) {
                        exception.setMessage(xmlPullParser.nextText());
                    } else if (tagFound.equals("short-stacktrace")) {
                        exception.setShortStackTrace(xmlPullParser.nextText());
                    } else if (tagFound.equals("full-stacktrace")) {
                        exception.setFullStackTrace(xmlPullParser.nextText());
                    }
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                tags.remove(tagFound);
            }
            return exception;
        }
        return null;
    }

    public boolean isStartTag(XmlPullParser xmlPullParser) {
        try {
            if (xmlPullParser != null) {
                return xmlPullParser.getEventType() == 2;
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean isText(XmlPullParser xmlPullParser) {
        try {
            if (xmlPullParser != null) {
                return xmlPullParser.getEventType() == 4;
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        return false;
    }

    public FileInputStream createFileInputStream(File file) {
        if (file != null && file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public XmlPullParser createXmlPullParser(BufferedInputStream bufferedInputStream) {
        block8: {
            try {
                if (bufferedInputStream == null) break block8;
                bufferedInputStream.available();
                try {
                    XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
                    xmlPullParserFactory.setNamespaceAware(true);
                    xmlPullParserFactory.setValidating(false);
                    try {
                        XmlPullParser xmlPullParser = xmlPullParserFactory.newPullParser();
                        try {
                            xmlPullParser.setInput((InputStream)bufferedInputStream, null);
                            return xmlPullParser;
                        }
                        catch (XmlPullParserException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (XmlPullParserException e) {
                        e.printStackTrace();
                    }
                }
                catch (XmlPullParserException e) {
                    log.severe("unable to create a new XmlPullParserFactory instance : error message : " + e.getMessage());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

