/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class TestResults
extends BaseResult
implements Serializable {
    private List<TestResult> testList = new ArrayList();
    private List<MethodResult> passedTests = new ArrayList();
    private List<MethodResult> failedTests = new ArrayList();
    private List<MethodResult> skippedTests = new ArrayList();
    private List<MethodResult> failedConfigurationMethods = new ArrayList();
    private List<MethodResult> skippedConfigurationMethods = new ArrayList();
    private int totalTestCount;
    private int passedTestCount;
    private int failedTestCount;
    private int skippedTestCount;
    private int failedConfigurationMethodsCount;
    private int skippedConfigurationMethodsCount;
    private Map<String, PackageResult> packageMap = new HashMap();

    public List<MethodResult> getFailedTests() {
        return this.failedTests;
    }

    public List<MethodResult> getPassedTests() {
        return this.passedTests;
    }

    public void setPassedTests(List<MethodResult> passedTests) {
        this.passedTests = passedTests;
    }

    public List<MethodResult> getSkippedTests() {
        return this.skippedTests;
    }

    public List<MethodResult> getFailedConfigurationMethods() {
        return this.failedConfigurationMethods;
    }

    public List<MethodResult> getSkippedConfigurationMethods() {
        return this.skippedConfigurationMethods;
    }

    public List<TestResult> getTestList() {
        return this.testList;
    }

    public void setTestList(List<TestResult> testList) {
        this.testList = testList;
    }

    public int getTotalTestCount() {
        return this.totalTestCount;
    }

    public void setTotalTestCount(int totalTestCount) {
        this.totalTestCount = totalTestCount;
    }

    public int getPassedTestCount() {
        return this.passedTestCount;
    }

    public void setPassedTestCount(int passedTestCount) {
        this.passedTestCount = passedTestCount;
    }

    public int getFailedTestCount() {
        return this.failedTestCount;
    }

    public void setFailedTestCount(int failedTestCount) {
        this.failedTestCount = failedTestCount;
    }

    public int getSkippedTestCount() {
        return this.skippedTestCount;
    }

    public void setSkippedTestCount(int skippedTestCount) {
        this.skippedTestCount = skippedTestCount;
    }

    public int getFailedConfigurationMethodsCount() {
        return this.failedConfigurationMethodsCount;
    }

    public void setFailedConfigurationMethodsCount(int failedConfigurationMethodsCount) {
        this.failedConfigurationMethodsCount = failedConfigurationMethodsCount;
    }

    public int getSkippedConfigurationMethodsCount() {
        return this.skippedConfigurationMethodsCount;
    }

    public void setSkippedConfigurationMethodsCount(int skippedConfigurationMethodsCount) {
        this.skippedConfigurationMethodsCount = skippedConfigurationMethodsCount;
    }

    public Map<String, PackageResult> getPackageMap() {
        return this.packageMap;
    }

    public Set<String> getPackageNames() {
        return this.packageMap.keySet();
    }

    public void setPackageMap(Map<String, PackageResult> packageMap) {
        this.packageMap = packageMap;
    }

    public void setFailedTests(List<MethodResult> failedTests) {
        this.failedTests = failedTests;
    }

    public void setSkippedTests(List<MethodResult> skippedTests) {
        this.skippedTests = skippedTests;
    }

    public void setFailedConfigurationMethods(List<MethodResult> failedConfigurationMethods) {
        this.failedConfigurationMethods = failedConfigurationMethods;
    }

    public void setSkippedConfigurationMethods(List<MethodResult> skippedConfigurationMethods) {
        this.skippedConfigurationMethods = skippedConfigurationMethods;
    }

    public static TestResults total(Collection<TestResults> ... results) {
        Collection merged = TestResults.merge((Collection[])results);
        TestResults total = new TestResults("");
        for (TestResults individual : merged) {
            total.add(individual, false);
        }
        total.tally();
        return total;
    }

    private void add(TestResults r, boolean tally) {
        this.testList.addAll(r.getTestList());
        this.failedConfigurationMethods.addAll(r.getFailedConfigurationMethods());
        this.skippedConfigurationMethods.addAll(r.getSkippedConfigurationMethods());
        this.failedTests.addAll(r.getFailedTests());
        this.passedTests.addAll(r.getPassedTests());
        this.skippedTests.addAll(r.getSkippedTests());
        if (tally) {
            this.tally();
        }
    }

    public void add(TestResults r) {
        this.add(r, true);
    }

    public static Collection<TestResults> merge(Collection<TestResults> ... results) {
        ArrayList<TestResults> newResults = new ArrayList<TestResults>();
        if (results.length == 0) {
            return Collections.emptySet();
        }
        if (results.length == 1) {
            return results[0];
        }
        ArrayList<String> indivNames = new ArrayList<String>();
        for (Collection<TestResults> result : results) {
            for (TestResults individual : result) {
                if (indivNames.contains(individual.name)) continue;
                indivNames.add(individual.name);
            }
        }
        for (String indivName : indivNames) {
            TestResults indivStat = new TestResults(indivName);
            for (Collection<TestResults> result : results) {
                for (TestResults individual : result) {
                    if (!indivName.equals(individual.name)) continue;
                    indivStat.add(individual);
                }
            }
            newResults.add(indivStat);
        }
        return newResults;
    }

    public TestResults(String name) {
        this.name = name;
    }

    public void setOwner(AbstractBuild<?, ?> owner) {
        this.owner = owner;
        for (TestResult _test : this.testList) {
            _test.setOwner(owner);
        }
        for (String pkg : this.packageMap.keySet()) {
            ((PackageResult)this.packageMap.get(pkg)).setOwner(owner);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestResults statistic = (TestResults)o;
        if (!this.name.equals(statistic.name)) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(statistic.owner) : statistic.owner != null);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "TestResults{name='" + this.name + '\'' + ", totalTests=" + this.totalTestCount + ", failedTests=" + this.failedTestCount + ", skippedTests=" + this.skippedTestCount + ", failedConfigurationMethods=" + this.failedConfigurationMethodsCount + ", skippedConfigurationMethods=" + this.skippedConfigurationMethodsCount + '}';
    }

    public String toSummary() {
        return "<ul>" + TestResults.diff((long)0L, (long)this.totalTestCount, (String)"Total Tests") + TestResults.diff((long)0L, (long)this.failedTestCount, (String)"Failed Tests") + TestResults.diff((long)0L, (long)this.skippedTestCount, (String)"Skipped Tests") + TestResults.diff((long)0L, (long)this.failedConfigurationMethodsCount, (String)"Failed Configurations") + TestResults.diff((long)0L, (long)this.skippedConfigurationMethodsCount, (String)"Skipped Configurations") + "</ul>";
    }

    private static String diff(long prev, long curr, String name) {
        if (prev <= curr) {
            return "<li>" + name + ": " + curr + " (+" + (curr - prev) + ")</li>";
        }
        return "<li>" + name + ": " + curr + " (-" + (prev - curr) + ")</li>";
    }

    public String toSummary(TestResults totals) {
        return "<ul>" + TestResults.diff((long)totals.getTotalTestCount(), (long)this.totalTestCount, (String)"Total Tests") + TestResults.diff((long)totals.getFailedTestCount(), (long)this.failedTestCount, (String)"Failed Tests") + TestResults.diff((long)totals.getSkippedTestCount(), (long)this.skippedTestCount, (String)"Skipped Tests") + TestResults.diff((long)totals.getFailedConfigurationMethodsCount(), (long)this.failedConfigurationMethodsCount, (String)"Failed Configurations") + TestResults.diff((long)totals.getSkippedConfigurationMethodsCount(), (long)this.skippedConfigurationMethodsCount, (String)"Skipped Configurations") + "</ul>";
    }

    public void set(TestResults that) {
        this.failedConfigurationMethods = that.getFailedConfigurationMethods();
        this.skippedConfigurationMethods = that.getSkippedConfigurationMethods();
        this.failedTests = that.getFailedTests();
        this.skippedTests = that.getSkippedTests();
        this.passedTests = that.getPassedTests();
        this.testList = that.getTestList();
    }

    public void tally() {
        this.failedConfigurationMethodsCount = this.failedConfigurationMethods.size();
        this.skippedConfigurationMethodsCount = this.skippedConfigurationMethods.size();
        this.failedTestCount = this.failedTests.size();
        this.passedTestCount = this.passedTests.size();
        this.skippedTestCount = this.skippedTests.size();
        this.totalTestCount = this.passedTestCount + this.failedTestCount + this.skippedTestCount;
        this.packageMap.clear();
        for (TestResult _test : this.testList) {
            for (ClassResult _class : _test.getClassList()) {
                String pkg = _class.getName();
                int lastDot = pkg.lastIndexOf(46);
                pkg = lastDot == -1 ? "No Package" : pkg.substring(0, lastDot);
                if (this.packageMap.containsKey(pkg)) {
                    ((PackageResult)this.packageMap.get(pkg)).getClassList().add(_class);
                    continue;
                }
                PackageResult tpkg = new PackageResult();
                tpkg.setName(pkg);
                tpkg.getClassList().add(_class);
                tpkg.setParent((BaseResult)this);
                this.packageMap.put(pkg, tpkg);
            }
        }
        for (String pkg : this.packageMap.keySet()) {
            ((PackageResult)this.packageMap.get(pkg)).tally();
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.packageMap.get(token);
    }
}

