/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.model.AbstractBuild;
import hudson.model.HealthReportingAction;
import hudson.plugins.helpers.AbstractBuildAction;
import hudson.plugins.helpers.GraphHelper;
import hudson.plugins.testng.PluginImpl;
import hudson.plugins.testng.TestNGResultAction;
import hudson.plugins.testng.results.TestResults;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildReport<T extends AbstractBuild<?, ?>>
extends AbstractBuildAction<T>
implements HealthReportingAction {
    private final TestResults results;

    public AbstractBuildReport(Collection<TestResults> results) {
        TestNGResultAction resultAction = new TestNGResultAction((AbstractBuild)this.getBuild());
        this.results = TestResults.total(results);
        resultAction.setTestNGResults(this.results);
    }

    public TestResults getResults() {
        return this.results;
    }

    public TestResults getPreviousResults() {
        AbstractBuild prevBuild;
        for (prevBuild = (AbstractBuild)this.getBuild().getPreviousBuild(); prevBuild != null && prevBuild.getAction(this.getClass()) == null; prevBuild = (AbstractBuild)prevBuild.getPreviousBuild()) {
        }
        if (prevBuild == null) {
            return new TestResults("");
        }
        AbstractBuildReport action = (AbstractBuildReport)prevBuild.getAction(this.getClass());
        return action.getResults();
    }

    @Override
    public String getSummary() {
        AbstractBuild prevBuild;
        for (prevBuild = (AbstractBuild)this.getBuild().getPreviousBuild(); prevBuild != null && prevBuild.getAction(this.getClass()) == null; prevBuild = (AbstractBuild)prevBuild.getPreviousBuild()) {
        }
        if (prevBuild == null) {
            return this.results.toSummary();
        }
        AbstractBuildReport action = (AbstractBuildReport)prevBuild.getAction(this.getClass());
        return this.results.toSummary(action.getResults());
    }

    public String getIconFileName() {
        return PluginImpl.ICON_FILE_NAME;
    }

    public String getDisplayName() {
        return PluginImpl.DISPLAY_NAME;
    }

    @Override
    public String getGraphName() {
        return PluginImpl.GRAPH_NAME;
    }

    public String getUrlName() {
        return PluginImpl.URL;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (GraphHelper.isGraphUnsupported()) {
            GraphHelper.redirectWhenGraphUnsupported(rsp, req);
            return;
        }
        Calendar t = this.getBuild().getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.buildChart(dataSetBuilder.build()), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    @Override
    public boolean isGraphActive() {
        Object build = this.getBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getClass()) != null) {
                ++numPoints;
            }
            build = (AbstractBuild)build.getPreviousBuild();
        }
        return true;
    }

    protected void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        for (Object build = this.getBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            AbstractBuildReport action = (AbstractBuildReport)build.getAction(this.getClass());
            if (action == null) continue;
            dataset.add((Number)action.getResults().getPassedTestCount(), (Comparable)((Object)"Passed"), (Comparable)label);
            dataset.add((Number)action.getResults().getFailedTestCount(), (Comparable)((Object)"Failed"), (Comparable)label);
            dataset.add((Number)action.getResults().getSkippedTestCount(), (Comparable)((Object)"Skipped"), (Comparable)label);
        }
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.getResults().getDynamic(token, req, rsp);
    }
}

