/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.maven.AggregatableAction;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.plugins.testng.AbstractBuildReport;
import hudson.plugins.testng.BuildIndividualReport;
import hudson.plugins.testng.ProjectAggregatedReport;
import hudson.plugins.testng.results.TestResults;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildAggregatedReport
extends AbstractBuildReport<MavenModuleSetBuild>
implements MavenAggregatedReport {
    private HealthReport buildHealth = null;

    public BuildAggregatedReport(MavenModuleSetBuild build, Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        super(new ArrayList<TestResults>());
        this.setBuild(build);
    }

    public synchronized void update(Map<MavenModule, List<MavenBuild>> moduleBuilds, MavenBuild newBuild) {
        BuildIndividualReport report = (BuildIndividualReport)newBuild.getAction(BuildIndividualReport.class);
        if (report != null) {
            this.getResults().add(report.getResults());
            this.buildHealth = HealthReport.min((HealthReport)this.buildHealth, (HealthReport)report.getBuildHealth());
        }
    }

    public Class<? extends AggregatableAction> getIndividualActionType() {
        return BuildIndividualReport.class;
    }

    public Action getProjectAction(MavenModuleSet moduleSet) {
        for (MavenModuleSetBuild build : moduleSet.getBuilds()) {
            if (build.getAction(BuildAggregatedReport.class) == null) continue;
            return new ProjectAggregatedReport(moduleSet);
        }
        return null;
    }

    public HealthReport getBuildHealth() {
        return this.buildHealth;
    }
}

