/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.maven.MavenReporter;
import hudson.maven.MavenReporterDescriptor;
import hudson.maven.MojoInfo;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.plugins.helpers.AbstractMavenReporterImpl;
import hudson.plugins.helpers.Ghostwriter;
import hudson.plugins.testng.BuildIndividualReport;
import hudson.plugins.testng.GhostWriter;
import hudson.plugins.testng.PluginImpl;
import hudson.plugins.testng.ProjectIndividualReport;
import java.io.File;
import net.sf.json.JSONObject;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class MavenPublisher
extends AbstractMavenReporterImpl {
    private static final String PLUGIN_GROUP_ID = "org.codehaus.mojo";
    private static final String PLUGIN_ARTIFACT_ID = "testng-plugin";
    private static final String PLUGIN_EXECUTE_GOAL = "report";
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public MavenPublisher() {
    }

    protected boolean isExecutingMojo(MojoInfo mojo) {
        return mojo.pluginName.matches(PLUGIN_GROUP_ID, PLUGIN_ARTIFACT_ID) && PLUGIN_EXECUTE_GOAL.equals(mojo.getGoal());
    }

    protected Ghostwriter newGhostwriter(MavenProject pom, MojoInfo mojo) {
        File xmlOutputDirectory;
        String tempFileName;
        try {
            tempFileName = (String)mojo.getConfigurationValue("tempFileName", String.class);
        }
        catch (ComponentConfigurationException e) {
            tempFileName = null;
        }
        if (tempFileName == null) {
            tempFileName = "testng-raw-report.xml";
        }
        System.out.println(tempFileName);
        File baseDir = pom.getBasedir().getAbsoluteFile();
        try {
            xmlOutputDirectory = (File)mojo.getConfigurationValue("xmlOutputDirector", File.class);
        }
        catch (ComponentConfigurationException e) {
            xmlOutputDirectory = null;
        }
        if (xmlOutputDirectory == null) {
            xmlOutputDirectory = new File(pom.getBuild().getDirectory());
        }
        System.out.println("***************" + baseDir);
        System.out.println(xmlOutputDirectory);
        String targetPath = this.makeDirEndWithFileSeparator(this.fixFilePathSeparator(xmlOutputDirectory.getAbsolutePath()));
        String baseDirPath = this.makeDirEndWithFileSeparator(this.fixFilePathSeparator(baseDir.getAbsolutePath()));
        String searchPath = targetPath.startsWith(baseDirPath) ? targetPath.substring(baseDirPath.length()) + tempFileName : "**/" + tempFileName;
        return new GhostWriter(searchPath);
    }

    private String makeDirEndWithFileSeparator(String baseDirPath) {
        if (!baseDirPath.endsWith(File.separator)) {
            baseDirPath = baseDirPath + File.separator;
        }
        return baseDirPath;
    }

    private String fixFilePathSeparator(String path) {
        return path.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar);
    }

    public Action getProjectAction(MavenModule module) {
        for (MavenBuild build : module.getBuilds()) {
            if (build.getAction(BuildIndividualReport.class) == null) continue;
            return new ProjectIndividualReport((AbstractProject<?, ?>)module);
        }
        return null;
    }

    public MavenReporterDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends MavenReporterDescriptor {
        private DescriptorImpl() {
            super(MavenPublisher.class);
        }

        public String getDisplayName() {
            return PluginImpl.DISPLAY_NAME;
        }

        public MavenReporter newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (MavenReporter)req.bindJSON(MavenPublisher.class, formData);
        }
    }
}

