/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageResult
extends BaseResult
implements ModelObject {
    private List<ClassResult> classList = new ArrayList<ClassResult>();
    private long duration;
    private int fail;
    private int skip;
    private int total;
    private List<MethodResult> sortedTestMethodsByStartTime = new ArrayList<MethodResult>();

    public String getUrl() {
        return this.getName();
    }

    @Override
    public void setOwner(AbstractBuild<?, ?> owner) {
        super.setOwner(owner);
        for (ClassResult _class : this.classList) {
            _class.setOwner(owner);
        }
    }

    public List<ClassResult> getClassList() {
        return this.classList;
    }

    public void setClassList(List<ClassResult> classList) {
        this.classList = classList;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getFail() {
        return this.fail;
    }

    public void setFail(int fail) {
        this.fail = fail;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public List<MethodResult> getSortedTestMethodsByStartTime() {
        this.sortTestMethods();
        return this.sortedTestMethodsByStartTime;
    }

    public void tally() {
        this.duration = 0L;
        this.fail = 0;
        this.skip = 0;
        this.total = 0;
        for (ClassResult _c : this.classList) {
            this.duration += _c.getDuration();
            this.fail += _c.getFail();
            this.skip += _c.getSkip();
            this.total += _c.getTotal();
            _c.setParent(this);
            _c.tally();
        }
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals("/" + this.getName())) {
            return this;
        }
        ClassResult result = null;
        for (ClassResult _c : this.classList) {
            if (!_c.getName().equals(token)) continue;
            result = _c;
            break;
        }
        return result;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public void sortTestMethods() {
        HashMap map = new HashMap();
        for (ClassResult aClass : this.classList) {
            if (aClass.getTestMethods() == null) continue;
            for (MethodResult aMethod : aClass.getTestMethods()) {
                if (aMethod.getStatus().equals("SKIP") || aMethod.getStartedAt() == null) continue;
                if (map.containsKey(aMethod.getStartedAt())) {
                    ((List)map.get(aMethod.getStartedAt())).add(aMethod);
                    continue;
                }
                ArrayList<MethodResult> list = new ArrayList<MethodResult>();
                list.add(aMethod);
                map.put(aMethod.getStartedAt(), list);
            }
        }
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys);
        this.sortedTestMethodsByStartTime.clear();
        for (Date key : keys) {
            if (!map.containsKey(key)) continue;
            this.sortedTestMethodsByStartTime.addAll((Collection)map.get(key));
        }
    }

    public long getFailedTestsCount() {
        int failedTests = 0;
        for (ClassResult aClass : this.classList) {
            if (aClass.getTestMethods() == null) continue;
            for (MethodResult aMethod : aClass.getTestMethods()) {
                if (!aMethod.getStatus().equals("FAIL")) continue;
                ++failedTests;
            }
        }
        return failedTests;
    }

    public long getSkippedTestsCount() {
        int skippedTests = 0;
        for (ClassResult aClass : this.classList) {
            if (aClass.getTestMethods() == null) continue;
            for (MethodResult aMethod : aClass.getTestMethods()) {
                if (aMethod.isConfig() || !aMethod.getStatus().equals("SKIP")) continue;
                ++skippedTests;
            }
        }
        return skippedTests;
    }

    public long getPassedTestsCount() {
        int passTests = 0;
        for (ClassResult aClass : this.classList) {
            if (aClass.getTestMethods() == null) continue;
            for (MethodResult aMethod : aClass.getTestMethods()) {
                if (!aMethod.getStatus().equals("PASS")) continue;
                ++passTests;
            }
        }
        return passTests;
    }

    public long getTotalTestsCount() {
        int totalTests = 0;
        for (ClassResult aClass : this.classList) {
            if (aClass.getTestMethods() == null) continue;
            for (MethodResult aMethod : aClass.getTestMethods()) {
                ++totalTests;
            }
        }
        return totalTests;
    }
}

