/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.parser;

import hudson.plugins.testng.parser.ResultPullParserHelper;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.TestResult;
import hudson.plugins.testng.results.TestResults;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.xmlpull.v1.XmlPullParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ResultsParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<TestResults> parse(File file, PrintStream printStream) {
        if (null == file) {
            if (printStream != null) {
                printStream.println("File not specified");
            }
            return Collections.EMPTY_LIST;
        }
        if (!file.exists() || file.isDirectory()) {
            if (printStream != null) {
                printStream.println("'" + file.getAbsolutePath() + "' points to a non-existent file or directory");
            }
            return Collections.EMPTY_LIST;
        }
        ResultPullParserHelper xmlParserHelper = new ResultPullParserHelper();
        ArrayList<TestResults> results = new ArrayList<TestResults>();
        FileInputStream fileInputStream = xmlParserHelper.createFileInputStream(file);
        if (fileInputStream != null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            XmlPullParser xmlPullParser = xmlParserHelper.createXmlPullParser(bufferedInputStream);
            if (xmlPullParser != null && xmlParserHelper.parseToTagIfFound(xmlPullParser, "testng-results", 0)) {
                while (xmlParserHelper.parseToTagIfFound(xmlPullParser, "suite", 1)) {
                    TestResults testNGTestResults = new TestResults(UUID.randomUUID().toString() + "_TestNGResults");
                    ArrayList<TestResult> testNGTestList = new ArrayList<TestResult>();
                    int suiteDepth = xmlPullParser.getDepth();
                    while (xmlParserHelper.parseToTagIfFound(xmlPullParser, "test", suiteDepth)) {
                        int testDepth = xmlPullParser.getDepth();
                        TestResult testngTest = new TestResult();
                        String name = xmlPullParser.getAttributeValue(null, "name");
                        testngTest.setName(name);
                        ArrayList<ClassResult> testNGClassList = new ArrayList<ClassResult>();
                        while (xmlParserHelper.parseToTagIfFound(xmlPullParser, "class", testDepth)) {
                            int classDepth = xmlPullParser.getDepth();
                            ClassResult testNGTestClass = new ClassResult();
                            testNGTestClass.setName(xmlPullParser.getAttributeValue(null, "name"));
                            testNGTestClass.setFullName(xmlPullParser.getAttributeValue(null, "name"));
                            ArrayList<MethodResult> testMethodList = new ArrayList<MethodResult>();
                            while (xmlParserHelper.parseToTagIfFound(xmlPullParser, "test-method", classDepth)) {
                                MethodResult testNGTestMethod = xmlParserHelper.createTestMethod(xmlPullParser, testNGTestClass);
                                if (testNGTestMethod == null) continue;
                                MethodResultException exception = xmlParserHelper.createExceptionObject(xmlPullParser);
                                if (exception != null) {
                                    testNGTestMethod.setException(exception);
                                }
                                ResultsParser.updateTestMethodLists((TestResults)testNGTestResults, (MethodResult)testNGTestMethod);
                                testMethodList.add(testNGTestMethod);
                            }
                            testNGTestClass.setTestMethodList(testMethodList);
                            testNGClassList.add(testNGTestClass);
                        }
                        testngTest.setClassList(testNGClassList);
                        testNGTestList.add(testngTest);
                    }
                    testNGTestResults.setTestList(testNGTestList);
                    testNGTestResults.tally();
                    results.add(testNGTestResults);
                    if (printStream == null) continue;
                    if (testNGTestResults.getTotalTestCount() > 0) {
                        printStream.println("Parsed TestNG XML Report at '" + file.getAbsolutePath() + "' and collected " + testNGTestResults.getTotalTestCount() + " test results");
                        continue;
                    }
                    printStream.println("Parsed TestNG XML Report at '" + file.getAbsolutePath() + "' and did not find any test results");
                }
            }
            try {
                bufferedInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return results;
    }

    private static void updateTestMethodLists(TestResults testResults, MethodResult testNGTestMethod) {
        if (testNGTestMethod.isConfig()) {
            if ("FAIL".equals(testNGTestMethod.getStatus())) {
                testResults.getFailedConfigurationMethods().add(testNGTestMethod);
            } else if ("SKIP".equals(testNGTestMethod.getStatus())) {
                testResults.getSkippedConfigurationMethods().add(testNGTestMethod);
            }
        } else if ("FAIL".equals(testNGTestMethod.getStatus())) {
            testResults.getFailedTests().add(testNGTestMethod);
        } else if ("SKIP".equals(testNGTestMethod.getStatus())) {
            testResults.getSkippedTests().add(testNGTestMethod);
        } else if ("PASS".equals(testNGTestMethod.getStatus())) {
            testResults.getPassedTests().add(testNGTestMethod);
        }
    }
}

