/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.model.AbstractBuild;
import hudson.model.HealthReportingAction;
import hudson.plugins.testng.PluginImpl;
import hudson.plugins.testng.results.TestResults;
import java.io.Serializable;
import java.util.Collection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildAction<BUILD extends AbstractBuild<?, ?>>
implements HealthReportingAction,
Serializable {
    private static final long serialVersionUID = 31415926L;
    private BUILD build = null;
    private final TestResults results;

    public AbstractBuildAction(Collection<TestResults> results) {
        this.results = TestResults.total(results);
    }

    public synchronized BUILD getBuild() {
        return this.build;
    }

    public synchronized void setBuild(BUILD build) {
        if (this.build == null && this.build != build) {
            this.build = build;
        }
    }

    public boolean isFloatingBoxActive() {
        return true;
    }

    public boolean isGraphActive() {
        return false;
    }

    public TestResults getResults() {
        return this.results;
    }

    public TestResults getPreviousResults() {
        AbstractBuild prevBuild;
        for (prevBuild = (AbstractBuild)this.getBuild().getPreviousBuild(); prevBuild != null && prevBuild.getAction(this.getClass()) == null; prevBuild = (AbstractBuild)prevBuild.getPreviousBuild()) {
        }
        if (prevBuild == null) {
            return new TestResults("");
        }
        AbstractBuildAction action = (AbstractBuildAction)prevBuild.getAction(this.getClass());
        return action.getResults();
    }

    public String getSummary() {
        AbstractBuild prevBuild;
        for (prevBuild = (AbstractBuild)this.getBuild().getPreviousBuild(); prevBuild != null && prevBuild.getAction(this.getClass()) == null; prevBuild = (AbstractBuild)prevBuild.getPreviousBuild()) {
        }
        if (prevBuild == null) {
            return this.results.toSummary();
        }
        AbstractBuildAction action = (AbstractBuildAction)prevBuild.getAction(this.getClass());
        return this.results.toSummary(action.getResults());
    }

    public String getIconFileName() {
        return PluginImpl.ICON_FILE_NAME;
    }

    public String getDisplayName() {
        return PluginImpl.DISPLAY_NAME;
    }

    public String getUrlName() {
        return PluginImpl.URL;
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.getResults().getDynamic(token, req, rsp);
    }
}

