/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.ProminentProjectAction;
import hudson.plugins.helpers.AbstractBuildAction;
import hudson.plugins.helpers.GraphHelper;
import hudson.plugins.testng.PluginImpl;
import hudson.plugins.testng.results.TestResults;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.util.Calendar;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectAction<PROJECT extends AbstractProject<?, ?>>
implements ProminentProjectAction {
    private final PROJECT project;

    protected AbstractProjectAction(PROJECT project) {
        this.project = project;
    }

    public PROJECT getProject() {
        return this.project;
    }

    public String getIconFileName() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildAction action = (AbstractBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return PluginImpl.ICON_FILE_NAME;
        }
        return null;
    }

    public String getDisplayName() {
        return PluginImpl.DISPLAY_NAME;
    }

    public String getGraphName() {
        return PluginImpl.GRAPH_NAME;
    }

    public String getUrlName() {
        return PluginImpl.URL;
    }

    public String getSearchUrl() {
        return PluginImpl.URL;
    }

    public void doGraph(StaplerRequest req, StaplerResponse rsp) throws IOException {
        if (GraphHelper.isGraphUnsupported()) {
            GraphHelper.redirectWhenGraphUnsupported(rsp, req);
            return;
        }
        Calendar t = ((AbstractBuild)this.getProject().getLastCompletedBuild()).getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        ChartUtil.generateGraph((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.createChart(req, dataSetBuilder.build()), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    public void doGraphMap(StaplerRequest req, StaplerResponse rsp) throws IOException {
        Calendar t = ((AbstractBuild)this.getProject().getLastCompletedBuild()).getTimestamp();
        if (req.checkIfModified(t, rsp)) {
            return;
        }
        DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        ChartUtil.generateClickableMap((StaplerRequest)req, (StaplerResponse)rsp, (JFreeChart)GraphHelper.createChart(req, dataSetBuilder.build()), (int)this.getGraphWidth(), (int)this.getGraphHeight());
    }

    public boolean isGraphActive() {
        AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = (AbstractBuild)build.getPreviousBuild();
        }
        return true;
    }

    public TestResults getResults() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildAction action = (AbstractBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action.getResults();
        }
        return null;
    }

    public AbstractBuildAction getLastCompletedBuildAction() {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastCompletedBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            AbstractBuildAction action = (AbstractBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action;
        }
        return null;
    }

    protected abstract Class<? extends AbstractBuildAction> getBuildActionClass();

    protected void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        for (AbstractBuild build = (AbstractBuild)this.getProject().getLastBuild(); build != null; build = (AbstractBuild)build.getPreviousBuild()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            AbstractBuildAction action = (AbstractBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            dataset.add((Number)action.getResults().getPassedTestCount(), (Comparable)((Object)"Passed"), (Comparable)label);
            dataset.add((Number)action.getResults().getFailedTestCount(), (Comparable)((Object)"Failed"), (Comparable)label);
            dataset.add((Number)action.getResults().getSkippedTestCount(), (Comparable)((Object)"Skipped"), (Comparable)label);
        }
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

