/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.helpers.BuildProxy;
import hudson.plugins.helpers.Ghostwriter;
import hudson.plugins.testng.BuildIndividualReport;
import hudson.plugins.testng.parser.ResultsParser;
import hudson.plugins.testng.results.TestResults;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GhostWriter
implements Ghostwriter,
Ghostwriter.MasterGhostwriter,
Ghostwriter.SlaveGhostwriter {
    private final String reportFilenamePattern;
    private final boolean isRelativePath;

    public GhostWriter(String reportFilenamePattern, boolean isRelativePath) {
        this.reportFilenamePattern = reportFilenamePattern;
        this.isRelativePath = isRelativePath;
    }

    @Override
    public boolean performFromMaster(AbstractBuild<?, ?> build, FilePath executionRoot, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    @Override
    public boolean performFromSlave(BuildProxy build, BuildListener listener) throws InterruptedException, IOException {
        Collection<TestResults> results = null;
        HashSet<String> parsedFiles = new HashSet<String>();
        if (!this.isRelativePath) {
            FilePath[] paths;
            for (FilePath path : paths = build.getExecutionRootDir().list(this.reportFilenamePattern)) {
                String pathStr = path.getRemote();
                if (parsedFiles.contains(pathStr)) continue;
                parsedFiles.add(pathStr);
                Collection<TestResults> result = ResultsParser.parse(new File(pathStr), listener.getLogger());
                if (results == null) {
                    results = result;
                    continue;
                }
                results.addAll(result);
            }
        } else {
            String executionRootDirRemotePath = build.getExecutionRootDir().getRemote();
            String testngResultXmlRelativePath = this.reportFilenamePattern;
            String testngResultXmlRemotePath = executionRootDirRemotePath + "/" + testngResultXmlRelativePath;
            Collection<TestResults> result = ResultsParser.parse(new File(testngResultXmlRemotePath), listener.getLogger());
            if (results == null) {
                results = result;
            } else {
                results.addAll(result);
            }
        }
        if (results != null) {
            BuildIndividualReport action = new BuildIndividualReport(results);
            build.getActions().add(action);
            TestResults r = TestResults.total(results);
            if (r.getFailedConfigurationMethodsCount() > 0 || r.getSkippedConfigurationMethodsCount() > 0 || r.getFailedTestCount() > 0 || r.getSkippedTestCount() > 0) {
                build.setResult(Result.UNSTABLE);
            }
        }
        return true;
    }
}

