/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.helpers.BuildProxy;
import hudson.plugins.helpers.Ghostwriter;
import hudson.remoting.Callable;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildProxyCallableHelper
implements Callable<BuildProxy, Exception>,
MavenBuildProxy.BuildCallable<Boolean, Exception> {
    private final BuildProxy buildProxy;
    private final Ghostwriter ghostwriter;
    private final BuildListener listener;

    BuildProxyCallableHelper(BuildProxy buildProxy, Ghostwriter ghostwriter, BuildListener listener) {
        this.buildProxy = buildProxy;
        this.ghostwriter = ghostwriter;
        this.listener = listener;
    }

    public Boolean call(MavenBuild mavenBuild) throws Exception {
        this.buildProxy.updateBuild((AbstractBuild)mavenBuild);
        if (this.ghostwriter instanceof Ghostwriter.MasterGhostwriter) {
            Ghostwriter.MasterGhostwriter masterBuildStep = (Ghostwriter.MasterGhostwriter)this.ghostwriter;
            return masterBuildStep.performFromMaster((AbstractBuild)mavenBuild, this.buildProxy.getExecutionRootDir(), this.listener);
        }
        return true;
    }

    public BuildProxy call() throws Exception {
        if (this.ghostwriter instanceof Ghostwriter.SlaveGhostwriter) {
            Ghostwriter.SlaveGhostwriter slaveBuildStep = (Ghostwriter.SlaveGhostwriter)this.ghostwriter;
            try {
                this.buildProxy.setContinueBuild(slaveBuildStep.performFromSlave(this.buildProxy, this.listener));
                return this.buildProxy;
            }
            catch (IOException e) {
                throw new Exception(e);
            }
            catch (InterruptedException e) {
                throw new Exception(e);
            }
        }
        return this.buildProxy;
    }
}

