/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestResults;
import hudson.plugins.testng.util.TestResultHistoryUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodResult
extends BaseResult
implements ModelObject {
    private String status;
    private String description;
    private boolean isConfig;
    private long duration;
    private MethodResultException exception;
    private Date startedAt;

    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public String getFullUrl() {
        return super.getParent().getParent().getName() + "/" + super.getParent().getName() + "/" + this.getUrl();
    }

    public MethodResultException getException() {
        return this.exception;
    }

    public void setException(MethodResultException exception) {
        this.exception = exception;
    }

    public String getUrl() {
        return this.getName();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isConfig() {
        return this.isConfig;
    }

    public void setConfig(boolean isConfig) {
        this.isConfig = isConfig;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals("/" + this.getName())) {
            return this;
        }
        return null;
    }

    public List<MethodResult> getPreviousMethodResults() {
        ArrayList<MethodResult> methodResults = new ArrayList<MethodResult>();
        List previousTestResults = TestResultHistoryUtil.getPreviousBuildTestResults((AbstractBuild)this.getOwner());
        if (previousTestResults != null) {
            block0: for (TestResults previousTestResult : previousTestResults) {
                Map previousPackageMap = previousTestResult.getPackageMap();
                String methodPackageName = this.getParent().getParent().getName();
                String methodClassName = this.getParent().getName();
                if (!previousPackageMap.containsKey(methodPackageName) || ((PackageResult)previousPackageMap.get(methodPackageName)).getClassList() == null) continue;
                List previousClassResults = ((PackageResult)previousPackageMap.get(this.getParent().getName())).getClassList();
                boolean foundMatch = false;
                for (ClassResult previousClassResult : previousClassResults) {
                    if (previousClassResult.getName().equals(methodClassName)) {
                        List previousMethodResults;
                        if (this.isConfig) {
                            if (previousClassResult.getConfigurationMethods() != null) {
                                previousMethodResults = previousClassResult.getConfigurationMethods();
                                for (MethodResult previousMethodResult : previousMethodResults) {
                                    if (!previousMethodResult.getName().equals(this.getName())) continue;
                                    methodResults.add(previousMethodResult);
                                    foundMatch = true;
                                    break;
                                }
                            }
                        } else if (previousClassResult.getTestMethods() != null) {
                            previousMethodResults = previousClassResult.getTestMethods();
                            for (MethodResult previousMethodResult : previousMethodResults) {
                                if (!previousMethodResult.getName().equals(this.getName())) continue;
                                methodResults.add(previousMethodResult);
                                foundMatch = true;
                                break;
                            }
                        }
                    }
                    if (!foundMatch) continue;
                    continue block0;
                }
            }
        }
        return methodResults;
    }

    public Object getCssClass() {
        if (this.status != null) {
            if (this.status.equalsIgnoreCase("pass")) {
                return "result-passed";
            }
            if (this.status.equalsIgnoreCase("skip")) {
                return "result-skipped";
            }
            if (this.status.equalsIgnoreCase("fail")) {
                return "result-failed";
            }
        }
        return "result-passed";
    }
}

