/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.helpers;

import hudson.model.AbstractBuild;
import hudson.model.HealthReportingAction;
import hudson.plugins.testng.results.TestResults;
import java.io.Serializable;
import java.util.Collection;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildAction<BUILD extends AbstractBuild<?, ?>>
implements HealthReportingAction,
Serializable {
    private static final long serialVersionUID = 31415926L;
    private BUILD build = null;
    private final TestResults results;

    protected AbstractBuildAction(Collection<TestResults> results) {
        this.results = TestResults.total(results);
    }

    public synchronized BUILD getBuild() {
        return this.build;
    }

    public synchronized void setBuild(BUILD build) {
        if (this.build == null && this.build != build) {
            this.build = build;
        }
    }

    public boolean isFloatingBoxActive() {
        return true;
    }

    public boolean isGraphActive() {
        return false;
    }

    public TestResults getResults() {
        return this.results;
    }

    public TestResults getPreviousResults() {
        AbstractBuild previousBuild;
        for (previousBuild = (AbstractBuild)this.getBuild().getPreviousBuild(); previousBuild != null && previousBuild.getAction(this.getClass()) == null; previousBuild = (AbstractBuild)previousBuild.getPreviousBuild()) {
        }
        if (previousBuild == null) {
            return new TestResults("");
        }
        AbstractBuildAction action = (AbstractBuildAction)previousBuild.getAction(this.getClass());
        return action.getResults();
    }

    public String getSummary() {
        return this.results.toSummary();
    }

    public String getIconFileName() {
        return "/plugin/testng-plugin/icons/report.png";
    }

    public String getDisplayName() {
        return "TestNG Results";
    }

    public String getUrlName() {
        return "testngreports";
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        return this.getResults().getDynamic(token, req, rsp);
    }
}

