/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import hudson.model.AbstractBuild;
import hudson.model.ModelObject;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.PackageResult;
import hudson.plugins.testng.results.TestResults;
import hudson.plugins.testng.util.TestResultHistoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResult
extends BaseResult
implements ModelObject {
    private List<MethodResult> testMethodList = new ArrayList<MethodResult>();
    private long duration;
    private int fail;
    private int skip;
    private int total;

    public String getUrl() {
        return this.getName();
    }

    @Override
    public void setOwner(AbstractBuild<?, ?> owner) {
        super.setOwner(owner);
        for (MethodResult _m : this.testMethodList) {
            _m.setOwner(owner);
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public int getFail() {
        return this.fail;
    }

    public void setFail(int fail) {
        this.fail = fail;
    }

    public int getSkip() {
        return this.skip;
    }

    public void setSkip(int skip) {
        this.skip = skip;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public void setTestMethodList(List<MethodResult> testMethodList) {
        this.testMethodList = testMethodList;
    }

    public long getFailedTestsDiffCount() {
        long diff = 0L;
        List<ClassResult> previousClassResults = this.getPreviousClassResults();
        if (previousClassResults != null && previousClassResults.size() > 0) {
            diff = this.getFail() - previousClassResults.get(0).getFail();
        }
        return diff;
    }

    public long getSkippedTestsDiffCount() {
        long diff = 0L;
        List<ClassResult> previousClassResults = this.getPreviousClassResults();
        if (previousClassResults != null && previousClassResults.size() > 0) {
            diff = this.getSkip() - previousClassResults.get(0).getSkip();
        }
        return diff;
    }

    public long getTotalTestsDiffCount() {
        long diff = 0L;
        List<ClassResult> previousClassResults = this.getPreviousClassResults();
        if (previousClassResults != null && previousClassResults.size() > 0) {
            diff = this.getTotal() - previousClassResults.get(0).getTotal();
        }
        return diff;
    }

    public long getAge() {
        List<ClassResult> previousClassResults = this.getPreviousClassResults();
        if (previousClassResults == null) {
            return 1L;
        }
        return 1 + previousClassResults.size();
    }

    public void tally() {
        this.duration = 0L;
        this.fail = 0;
        this.skip = 0;
        this.total = 0;
        for (MethodResult methodResult : this.testMethodList) {
            if (!methodResult.isConfig()) {
                this.duration += methodResult.getDuration();
                ++this.total;
                if ("FAIL".equals(methodResult.getStatus())) {
                    ++this.fail;
                } else if ("SKIP".equals(methodResult.getStatus())) {
                    ++this.skip;
                }
            }
            methodResult.setParent(this);
        }
    }

    public String getDisplayName() {
        return this.getName();
    }

    public Object getDynamic(String token, StaplerRequest req, StaplerResponse rsp) {
        if (token.equals("/" + this.getName())) {
            return this;
        }
        if (this.testMethodList != null) {
            for (MethodResult methodResult : this.testMethodList) {
                if (!token.equals(methodResult.getName())) continue;
                return methodResult;
            }
        }
        return null;
    }

    public List<MethodResult> getTestMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }

    public List<MethodResult> getConfigurationMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (!methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }

    public List<ClassResult> getPreviousClassResults() {
        ArrayList<ClassResult> classResults = new ArrayList<ClassResult>();
        List<TestResults> previousTestResults = TestResultHistoryUtil.getPreviousBuildTestResults(this.getOwner());
        if (previousTestResults != null) {
            block0: for (TestResults previousTestResult : previousTestResults) {
                String classPackageName;
                Map<String, PackageResult> previousPackageMap = previousTestResult.getPackageMap();
                if (!previousPackageMap.containsKey(classPackageName = this.getParent().getName()) || previousPackageMap.get(classPackageName).getClassList() == null) continue;
                List<ClassResult> previousClassResults = previousPackageMap.get(this.getParent().getName()).getClassList();
                for (ClassResult previousClassResult : previousClassResults) {
                    if (!previousClassResult.getName().equals(this.getName())) continue;
                    classResults.add(previousClassResult);
                    continue block0;
                }
            }
        }
        return classResults;
    }
}

