/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.textfinder;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.textfinder.TextFinderPublisher;
import hudson.remoting.RemoteOutputStream;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFinderPublisher
extends Publisher
implements Serializable {
    private final String fileSet;
    private final String regexp;
    private final boolean succeedIfFound;
    private static final long serialVersionUID = 1L;

    TextFinderPublisher(String fileSet, String regexp, boolean succeedIfFound) {
        this.fileSet = fileSet;
        this.regexp = regexp;
        this.succeedIfFound = succeedIfFound;
        try {
            Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
    }

    public String getFileSet() {
        return this.fileSet;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public boolean getSucceedIfFound() {
        return this.succeedIfFound;
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.findText(build, listener.getLogger());
        return true;
    }

    private void findText(Build build, PrintStream logger) throws IOException, InterruptedException {
        logger.println("Checking " + this.regexp);
        RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
        try {
            Boolean foundText = (Boolean)((Project)build.getProject()).getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */);
            if (foundText != this.succeedIfFound) {
                build.setResult(Result.FAILURE);
            }
        }
        catch (AbortException e) {
            build.setResult(Result.UNSTABLE);
        }
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    static /* synthetic */ String access$000(TextFinderPublisher x0) {
        return x0.fileSet;
    }

    static /* synthetic */ String access$200(TextFinderPublisher x0) {
        return x0.regexp;
    }
}

