/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.textfinder;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.plugins.textfinder.TextFinderPublisher;
import hudson.remoting.RemoteOutputStream;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFinderPublisher
extends Publisher
implements Serializable {
    public final String fileSet;
    public final String regexp;
    public final boolean succeedIfFound;
    public final boolean alsoCheckConsoleOutput;
    private static final long serialVersionUID = 1L;

    public TextFinderPublisher(String fileSet, String regexp, boolean succeedIfFound, boolean alsoCheckConsoleOutput) {
        this.fileSet = Util.fixEmpty((String)fileSet.trim());
        this.regexp = regexp;
        this.succeedIfFound = succeedIfFound;
        this.alsoCheckConsoleOutput = alsoCheckConsoleOutput;
        try {
            Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
    }

    public boolean perform(Build build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        this.findText(build, listener.getLogger());
        return true;
    }

    private void findText(Build build, PrintStream logger) throws IOException, InterruptedException {
        try {
            boolean foundText = false;
            if (this.alsoCheckConsoleOutput) {
                logger.println("Checking console output");
                foundText |= this.checkFile(build.getLogFile(), this.compilePattern(logger), logger, true);
            } else {
                logger.println("Checking " + this.regexp);
            }
            RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
            if (this.fileSet != null) {
                foundText |= ((Boolean)((Project)build.getProject()).getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */)).booleanValue();
            }
            if (foundText != this.succeedIfFound) {
                build.setResult(Result.FAILURE);
            }
        }
        catch (AbortException e) {
            build.setResult(Result.UNSTABLE);
        }
    }

    private boolean checkFile(File f, Pattern pattern, PrintStream logger, boolean abortAfterFirstHit) {
        boolean logFilename = true;
        boolean foundText = false;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (logFilename) {
                    logger.println(f + ":");
                    logFilename = false;
                }
                logger.println(line);
                foundText = true;
                if (!abortAfterFirstHit) continue;
                return true;
            }
        }
        catch (IOException e) {
            logger.println("Hudson Text Finder: Error reading file '" + f + "' -- ignoring");
        }
        return foundText;
    }

    private Pattern compilePattern(PrintStream logger) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(this.regexp);
        }
        catch (PatternSyntaxException e) {
            logger.println("Hudson Text Finder: Unable to compileregular expression '" + this.regexp + "'");
            throw new AbortException(null);
        }
        return pattern;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    static /* synthetic */ Pattern access$100(TextFinderPublisher x0, PrintStream x1) {
        return x0.compilePattern(x1);
    }

    static /* synthetic */ boolean access$200(TextFinderPublisher x0, File x1, Pattern x2, PrintStream x3, boolean x4) {
        return x0.checkFile(x1, x2, x3, x4);
    }
}

