/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.textfinder;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.remoting.RemoteOutputStream;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormFieldValidator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFinderPublisher
extends Publisher
implements Serializable {
    public final String fileSet;
    public final String regexp;
    public final boolean succeedIfFound;
    public final boolean unstableIfFound;
    public final boolean alsoCheckConsoleOutput;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public TextFinderPublisher(String fileSet, String regexp, boolean succeedIfFound, boolean unstableIfFound, boolean alsoCheckConsoleOutput) {
        this.fileSet = Util.fixEmpty((String)fileSet.trim());
        this.regexp = regexp;
        this.succeedIfFound = succeedIfFound;
        this.unstableIfFound = unstableIfFound;
        this.alsoCheckConsoleOutput = alsoCheckConsoleOutput;
        try {
            Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.findText(build, listener.getLogger());
        return true;
    }

    private void findText(AbstractBuild build, PrintStream logger) throws IOException, InterruptedException {
        try {
            boolean foundText = false;
            if (this.alsoCheckConsoleOutput) {
                logger.println("Checking console output");
                foundText |= this.checkFile(build.getLogFile(), this.compilePattern(logger), logger, true);
            } else {
                logger.println("Checking " + this.regexp);
            }
            final RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
            if (this.fileSet != null) {
                foundText |= ((Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<Boolean>(){

                    public Boolean invoke(File ws, VirtualChannel channel) throws IOException {
                        PrintStream logger = new PrintStream((OutputStream)ros);
                        FileSet fs = new FileSet();
                        Project p = new Project();
                        fs.setProject(p);
                        fs.setDir(ws);
                        fs.setIncludes(TextFinderPublisher.this.fileSet);
                        DirectoryScanner ds = fs.getDirectoryScanner(p);
                        String[] files = ds.getIncludedFiles();
                        if (files.length == 0) {
                            logger.println("Hudson Text Finder: File set '" + TextFinderPublisher.this.fileSet + "' is empty");
                            throw new AbortException();
                        }
                        Pattern pattern = TextFinderPublisher.this.compilePattern(logger);
                        boolean foundText = false;
                        for (String file : files) {
                            File f = new File(ws, file);
                            if (!f.exists()) {
                                logger.println("Hudson Text Finder: Unable to find file '" + f + "'");
                                continue;
                            }
                            if (!f.canRead()) {
                                logger.println("Hudson Text Finder: Unable to read from file '" + f + "'");
                                continue;
                            }
                            foundText |= TextFinderPublisher.this.checkFile(f, pattern, logger, false);
                        }
                        return foundText;
                    }
                })).booleanValue();
            }
            if (foundText != this.succeedIfFound) {
                build.setResult(this.unstableIfFound ? Result.UNSTABLE : Result.FAILURE);
            }
        }
        catch (AbortException e) {
            build.setResult(Result.UNSTABLE);
        }
    }

    private boolean checkFile(File f, Pattern pattern, PrintStream logger, boolean abortAfterFirstHit) {
        boolean logFilename = true;
        boolean foundText = false;
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(f));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (logFilename) {
                    logger.println(f + ":");
                    logFilename = false;
                }
                logger.println(line);
                foundText = true;
                if (!abortAfterFirstHit) continue;
                return true;
            }
        }
        catch (IOException e) {
            logger.println("Hudson Text Finder: Error reading file '" + f + "' -- ignoring");
        }
        return foundText;
    }

    private Pattern compilePattern(PrintStream logger) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(this.regexp);
        }
        catch (PatternSyntaxException e) {
            logger.println("Hudson Text Finder: Unable to compileregular expression '" + this.regexp + "'");
            throw new AbortException();
        }
        return pattern;
    }

    public Descriptor<Publisher> getDescriptor() {
        return DescriptorImpl.DESCRIPTOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

        private DescriptorImpl() {
            super(TextFinderPublisher.class);
        }

        public String getDisplayName() {
            return "Hudson Text Finder";
        }

        public String getHelpFile() {
            return "/plugin/text-finder/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public void doCheckRegexp(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            new FormFieldValidator(req, rsp, true){

                protected void check() throws IOException, ServletException {
                    String value = Util.fixEmpty((String)this.request.getParameter("value"));
                    if (value == null) {
                        this.ok();
                        return;
                    }
                    try {
                        Pattern.compile(value);
                        this.ok();
                    }
                    catch (PatternSyntaxException e) {
                        this.error(e.getMessage());
                    }
                }
            }.process();
        }
    }

    private static final class AbortException
    extends RuntimeException {
        private AbortException() {
        }
    }
}

