/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.textfinder;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.textfinder.TextFinderPublisher;
import hudson.remoting.RemoteOutputStream;
import hudson.tasks.Publisher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFinderPublisher
extends Publisher
implements Serializable {
    public final String fileSet;
    public final String regexp;
    public final boolean succeedIfFound;
    public final boolean unstableIfFound;
    public final boolean alsoCheckConsoleOutput;
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public TextFinderPublisher(String fileSet, String regexp, boolean succeedIfFound, boolean unstableIfFound, boolean alsoCheckConsoleOutput) {
        this.fileSet = Util.fixEmpty((String)fileSet.trim());
        this.regexp = regexp;
        this.succeedIfFound = succeedIfFound;
        this.unstableIfFound = unstableIfFound;
        this.alsoCheckConsoleOutput = alsoCheckConsoleOutput;
        try {
            Pattern.compile(regexp);
        }
        catch (PatternSyntaxException e) {
            // empty catch block
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        this.findText(build, listener.getLogger());
        return true;
    }

    private void findText(AbstractBuild build, PrintStream logger) throws IOException, InterruptedException {
        try {
            boolean foundText = false;
            if (this.alsoCheckConsoleOutput) {
                logger.println("Checking console output");
                foundText |= this.checkFile(build.getLogFile(), this.compilePattern(logger), logger, true);
            } else {
                logger.println("Checking " + this.regexp);
            }
            RemoteOutputStream ros = new RemoteOutputStream((OutputStream)logger);
            if (this.fileSet != null) {
                foundText |= ((Boolean)build.getProject().getWorkspace().act((FilePath.FileCallable)new /* Unavailable Anonymous Inner Class!! */)).booleanValue();
            }
            if (foundText != this.succeedIfFound) {
                build.setResult(this.unstableIfFound ? Result.UNSTABLE : Result.FAILURE);
            }
        }
        catch (AbortException e) {
            build.setResult(Result.UNSTABLE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFile(File f, Pattern pattern, PrintStream logger, boolean abortAfterFirstHit) {
        boolean bl;
        boolean logFilename = true;
        boolean foundText = false;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(f));
            while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                if (logFilename) {
                    logger.println(f + ":");
                    logFilename = false;
                }
                logger.println(line);
                foundText = true;
                if (!abortAfterFirstHit) continue;
                bl = true;
            }
        }
        catch (IOException e) {
            try {
                logger.println("Hudson Text Finder: Error reading file '" + f + "' -- ignoring");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
            return foundText;
        }
        IOUtils.closeQuietly((Reader)reader);
        return foundText;
        IOUtils.closeQuietly((Reader)reader);
        return bl;
    }

    private Pattern compilePattern(PrintStream logger) {
        Pattern pattern;
        try {
            pattern = Pattern.compile(this.regexp);
        }
        catch (PatternSyntaxException e) {
            logger.println("Hudson Text Finder: Unable to compileregular expression '" + this.regexp + "'");
            throw new AbortException(null);
        }
        return pattern;
    }

    static /* synthetic */ Pattern access$100(TextFinderPublisher x0, PrintStream x1) {
        return x0.compilePattern(x1);
    }

    static /* synthetic */ boolean access$200(TextFinderPublisher x0, File x1, Pattern x2, PrintStream x3, boolean x4) {
        return x0.checkFile(x1, x2, x3, x4);
    }
}

